% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk-adjusted-comparisons.R
\docType{class}
\name{RiskAdjustedComparisons}
\alias{RiskAdjustedComparisons}
\title{Make risk adjusted comparisons between groups/units or years/months}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
RiskAdjustedComparisons(df, predictedCol, groupCol, impute)
}
\arguments{
\item{df}{Dataframe whose columns are used for calc.}

\item{predictedCol}{Column that you want to predict.}

\item{groupCol}{Column that we'll use to differentiate}

\item{impute}{Set all-column imputation to F or T.}
}
\description{
This class allows you to create a model based on the
performance of many groups in a cohort (besides group A, for example) and
see how well group A does against what the model would predict. Ranking each
of the groups this way provides a sense of which group's doing best in
terms of a particular measure.
}
\examples{

#### Example using SQL data ####

\dontrun{
library(healthcareai)

connection.string <- "
driver={SQL Server};
server=localhost;
database=SAM;
trusted_connection=true
"

query <- "
SELECT
[PatientEncounterID]
,[PatientID]
,[SystolicBPNBR]
,[LDLNBR]
,[A1CNBR]
,[GenderFLG]
,[ThirtyDayReadmitFLG]
FROM [SAM].[dbo].[HCRDiabetesClinical]
"

df <- selectData(connection.string, query)

p <- SupervisedModelDevelopmentParams$new()
p$df <- df
p$groupCol <- "GenderFLG"
p$impute <- TRUE
p$predictedCol <- "ThirtyDayReadmitFLG"
p$debug <- FALSE
p$cores <- 1

riskAdjComp <- RiskAdjustedComparisons$new(p)
riskAdjComp$run()
}

}
\references{
\url{http://healthcareai-r.readthedocs.io}
}
\seealso{
\code{\link{healthcareai}}
}
\keyword{datasets}
