% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_3_model_method.R
\name{print.hdnom.model}
\alias{print.hdnom.model}
\title{Print high-dimensional Cox model objects}
\usage{
\method{print}{hdnom.model}(x, ...)
}
\arguments{
\item{x}{Model object.}

\item{...}{Other parameters (not used).}
}
\description{
Print high-dimensional Cox model objects
}
\examples{
data("smart")
x <- as.matrix(smart[, -c(1, 2)])
time <- smart$TEVENT
event <- smart$EVENT
y <- survival::Surv(time, event)

fit <- fit_lasso(x, y, nfolds = 5, rule = "lambda.1se", seed = 11)
print(fit)
}
