% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.hdnom.models.R
\name{hdnom.varinfo}
\alias{hdnom.varinfo}
\title{Extract Information of Selected Variables from High-Dimensional Cox Models}
\usage{
hdnom.varinfo(object, x)
}
\arguments{
\item{object}{Model object fitted by \code{hdcox.*()} functions.}

\item{x}{Data matrix used to fit the model.}
}
\value{
A list containing the index, name, type and range of the
selected variables.
}
\description{
Extract the names and type of selected variables from established
high-dimensional Cox models.
}
\examples{
library("survival")

# Load imputed SMART data
data("smart")
x = as.matrix(smart[, -c(1, 2)])
time = smart$TEVENT
event = smart$EVENT
y = Surv(time, event)

# Fit Cox model by lasso penalization
lassofit = hdcox.lasso(x, y, nfolds = 5, rule = "lambda.1se", seed = 11)
hdnom.varinfo(lassofit, x)
}

