% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsc.R
\name{dsc}
\alias{dsc}
\title{Generate dynamic subset forecast combinations}
\usage{
dsc(gamma_grid, psi_grid, y, mu_mat, var_mat, delta, n_cores)
}
\arguments{
\item{gamma_grid}{A numerical vector that contains discount factors
to exponentially down-weight the past predictive performance
of the candidate forecasts.}

\item{psi_grid}{An integer vector that controls
the (possible) sizes of the active subsets.}

\item{y}{A matrix of dimension `T * 1` or numeric vector of length `T`
containing the observations of the target variable.}

\item{mu_mat}{A matrix with `T` rows containing
the first moment of each predictive density in each column.}

\item{var_mat}{A matrix with `T` rows containing
the second moment of each predictive density in each column.}

\item{delta}{A numeric value denoting the discount factor used
to down-weight the past predictive performance of the subset combinations.}

\item{n_cores}{An integer that denotes the number of CPU-cores
used for the computational estimation.}
}
\value{
A list that contains:
* (1) a vector with the first moments (point forecasts) of the STSC-Model,
* (2) a vector with the the second moments (variance) of the STSC-Model,
* (3) a vector that contains the selected values for gamma,
* (4) a vector that contains the selected values for psi and
* (5) a matrix that indicates the selected signals for every point in time.
}
\description{
`dsc()` can be used to generate forecast combinations
from a set of candidate density forecasts. For each period,
`dsc()` selects a subset of predictive densities with highest ranks
regarding (local) predictive accuracy.
Both the identities of the candidate forecasts
that are used for building the combined forecast and
the subset sizes may vary over time based on the data.
If only one candidate forecast is picked, the approach (temporarily)
collapses to pure model selection.
}
\examples{
\donttest{

# See example for tvc().

}
}
\references{
Beckmann, J., Koop, G., Korobilis, D., and Schüssler, R. A. (2020) "Exchange rate predictability and dynamic bayesian learning."
\emph{Journal of Applied Econometrics}, 35 (4): 410–421.

Koop, G. and Korobilis, D. (2012) "Forecasting inflation using dynamic model averaging."
\emph{International Economic Review}, 53 (3): 867–886.

Koop, G. and Korobilis, D. (2023) "Bayesian dynamic variable selection in high dimensions."
\emph{International Economic Review}.

Raftery, A. E., Kárn`y, M., and Ettler, P. (2010) "Online prediction under model uncertainty via dynamic model averaging: Application to a cold rolling mill."
\emph{Technometrics}, 52 (1): 52–66.

Del Negro, M., Hasegawa, R. B., and Schorfheide, F. (2016) "Dynamic prediction pools: An investigation of financial frictions and forecasting performance."
\emph{Journal of Econometrics}, 192 (2): 391–405.

West, M. and Harrison, J. (1997) "Bayesian forecasting and dynamic models"
\emph{Springer}, 2nd edn.
}
\seealso{
\url{https://github.com/lehmasve/hdflex#readme}
}
\author{
Philipp Adämmer, Sven Lehmann, Rainer Schüssler
}
