% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{create_empty}
\alias{create_empty}
\title{Create an empty R-object according to a given HDF5 datatype}
\usage{
create_empty(nelem, dtype)
}
\arguments{
\item{nelem}{The number of elements to use for the object}

\item{dtype}{The datatype based on which an empty R-object should be created}
}
\value{
An empty R object corresponding to the datatype that was passed in
}
\description{
Create an empty R-object according to a given HDF5 datatype
}
\details{
With complex datatypes it can be useful to have a template that can be used so that the
data input into a dataset conforms to expectations.

Given a datatype, this function creates an object of length \code{nelem}.
Here, an empty datatype refers to objects with value 0 for numeric objects and
empty strings.
}
\author{
Holger Hoefling
}
