% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hdf5-methods.R
\name{h5List}
\alias{h5List}
\alias{h5List.H5Group}
\alias{h5List.H5File}
\alias{h5List.character}
\title{List the contents of an HDF5 group}
\usage{
h5List(x, ...)

\method{h5List}{H5Group}(
  x,
  recursive = FALSE,
  full.names = FALSE,
  simplify = TRUE,
  detailed = FALSE,
  ...
)

\method{h5List}{H5File}(
  x,
  name = "/",
  recursive = FALSE,
  full.names = FALSE,
  simplify = TRUE,
  detailed = FALSE,
  ...
)

\method{h5List}{character}(
  x,
  name = "/",
  recursive = FALSE,
  full.names = FALSE,
  simplify = TRUE,
  detailed = FALSE,
  ...
)
}
\arguments{
\item{x}{An \code{\link[hdf5r]{H5File}}, \code{\link[hdf5r]{H5Group}} or a 
path name of HDF5 file.}

\item{...}{Additional parameters passed to \code{$ls()}}

\item{recursive}{If TRUE, the contents of the whole group hierarchy will be 
listed.}

\item{full.names}{Whether or not to return the absolute object path names.}

\item{simplify}{Whether or not to only return the object names.}

\item{detailed}{Whether or not to show the detailed information.}

\item{name}{A link in file. Must refer to an H5Group. Default is "/".}
}
\value{
If \code{simplify}, will return a character vector specifying names of H5 
links, otherwise will return a \code{data.frame} to show details.
}
\description{
Function to list the contents of an HDF5 group.
}
\examples{
file <- system.file("extdata", "pbmc_small.h5ad", package = "hdf5r.Extra")

h5List(file)
h5List(file, "obs")
h5List(file, recursive = TRUE)
h5List(file, "obs", simplify = FALSE, recursive = TRUE)

h5g <- h5Open(file, "obs", mode = "r")
h5List(h5g)

}
\seealso{
\code{\link[hdf5r]{H5Group}}\code{$ls()}
}
