% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bboxSpatialPolygon.R
\name{bboxSpatialPolygon}
\alias{bboxSpatialPolygon}
\title{Convert a bounding box to a SpatialPolygons object
Bounding box is first created (in lat/lon) then projected if specified}
\usage{
bboxSpatialPolygon(bbox, proj4stringFrom = NULL, proj4stringTo = NULL)
}
\arguments{
\item{bbox}{Bounding box: a 2x2 numerical matrix of lat/lon coordinates}

\item{proj4stringFrom}{Projection string for the current bbox coordinates (defaults to lat/lon, WGS84)}

\item{proj4stringTo}{Projection string, or NULL to not project}
}
\value{
A SpatialPolygons object of the bounding box
}
\description{
Convert a bounding box to a SpatialPolygons object
Bounding box is first created (in lat/lon) then projected if specified
}
\examples{
\dontrun{
  bbox <- list(lonMin=-180,latMin=-50,lonMax=+180,latMax=+50)
  bbSP <- bboxSpatialPolygon(bbox)
}

}
\references{
http://gis.stackexchange.com/questions/46954/clip-spatial-object-to-bounding-box-in-r
}

