% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.mixturecure}
\alias{print.mixturecure}
\title{Print the contents of a mixture cure fitted object}
\usage{
\method{print}{mixturecure}(x, ...)
}
\arguments{
\item{x}{a \code{mixturecure} object resulting from \code{curegmifs}, \code{cureem}, \code{cv_cureem}, or \code{cv_curegmifs}.}

\item{...}{other arguments.}
}
\value{
names of the objects in a mixturecure object fit using \code{cureem}, \code{curegmifs}, \code{cv_cureem}, or \code{cv_curegmifs}.
}
\description{
This function prints the names of the list objects from a \code{curegmifs}, \code{cureem}, \code{cv_cureem}, or \code{cv_curegmifs} fitted model.
}
\note{
The contents of an \code{mixturecure} fitted object differ depending upon whether the EM (\code{cureem}) or GMIFS (\code{curegmifs}) algorithm is used for model fitting. Also, the output differs depending upon whether \code{x.latency} is specified in the model (i.e., variables are included in the latency portion of the model fit) or only \code{terms} on the right hand side of the equation are included (i.e., variables are included in the incidence portion of the model).
}
\examples{
library(survival)
set.seed(1234)
temp <- generate_cure_data(N = 100, J = 10, nTrue = 10, A = 1.8)
training <- temp$Training
fit <- curegmifs(Surv(Time, Censor) ~ .,
                       data = training, x.latency = training,
                       model = "weibull", thresh = 1e-4, maxit = 2000,
                       epsilon = 0.01, verbose = FALSE)
print(fit)
}
\seealso{
\code{\link{curegmifs}}, \code{\link{cureem}}, \code{\link{coef.mixturecure}}, \code{\link{summary.mixturecure}}, \code{\link{plot.mixturecure}}, \code{\link{predict.mixturecure}}
}
\keyword{methods}
