% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/majority_rule.R
\name{majority_rule_mxPBF}
\alias{majority_rule_mxPBF}
\title{Majority Rule for Multiscale approach using mxPBF Results}
\usage{
majority_rule_mxPBF(result_mxPBFs, nws, n)
}
\arguments{
\item{result_mxPBFs}{A list of results from \code{mxPBF_mean()} or \code{mxPBF_cov()}.}

\item{nws}{A vector of window sizes used for \code{mxPBF_mean()} or \code{mxPBF_cov()}.}

\item{n}{The total number of observations in the dataset.}
}
\value{
A vector of final detected change points that are common across multiple windows based on majority rule.
}
\description{
This function implements a majority rule-based post-processing approach to identify common change points across multiple window sizes from mxPBF results.
}
\examples{
\donttest{
n <- 500
p <- 200
signal_size <- 1
pre_value <- 0.3
pre_proportion <- 0.4
given_data <- generate_mean_datasets(n, p, signal_size, pre_proportion, pre_value,
single_point = 250, multiple_points = c(150,300,350), type = 5)
nws <- c(25, 60, 100)
alps <- seq(1,10,0.05)
res_mxPBF <- mxPBF_mean(given_data, nws, alps)
majority_rule_mxPBF(res_mxPBF, nws, n)
}

}
