% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcWO_formula.R
\name{calcWO.formula}
\alias{calcWO.formula}
\title{Win odds calculation using formula syntax}
\usage{
\method{calcWO}{formula}(x, data, ...)
}
\arguments{
\item{x}{an object of class formula.}

\item{data}{a data frame.}

\item{...}{additional parameters.}
}
\value{
a data frame containing the win odds and its confidence interval. It contains the following columns:
\itemize{
\item WO calculated win odds.
\item LCL lower confidence limit.
\item UCL upper confidence limit.
\item SE standard error of the win odds.
\item WOnull win odds of the null hypothesis (specified in the \code{WOnull} argument).
\item alpha two-sided significance level for calculating the confidence interval (specified in the \code{alpha} argument).
\item Pvalue p-value associated with testing the null hypothesis.
}
}
\description{
Win odds calculation using formula syntax
}
\examples{
data(HCE1)
calcWO(AVAL ~ TRTP, data = HCE1)

}
