% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_apicarto_gpu.R
\name{get_apicarto_gpu}
\alias{get_apicarto_gpu}
\title{Apicarto module Geoportail de l'urbanisme}
\usage{
get_apicarto_gpu(x,
                 ressource = "zone-urba",
                 categorie = list(NULL),
                 dTolerance = 0)
}
\arguments{
\item{x}{An object of class \code{sf} or \code{sfc} for geometric intersection. Otherwise
a \code{character} corresponding to \strong{GPU partition} or
\strong{insee code} when \code{ressource} is set to \code{municipality}.}

\item{ressource}{A character from this list : "document", "zone-urba",
"secteur-cc", "prescription-surf", "prescription-lin", "prescription-pct",
"info-surf", "info-lin", "info-pct". See detail for more info.}

\item{categorie}{public utility easement according to the
\href{http://www.geoinformations.developpement-durable.gouv.fr/nomenclature-nationale-des-sup-r1082.html}{national nomenclature}}

\item{dTolerance}{numeric; Complex shape cannot be handle by API; using \code{dTolerance} allow to simplify them. See \code{?sf::st_simplify}}
}
\value{
A object of class \code{sf} or \code{df}
}
\description{
Apicarto module Geoportail de l'urbanisme
}
\details{
\strong{/!\ For the moment the API cannot returned more than 5000 features.}

All existing parameters for \code{ressource} :
\itemize{
\item "municipality : information on the communes (commune with RNU, merged commune)
\item "document' : information on urban planning documents (POS, PLU, PLUi, CC, PSMV)
\item "zone-urba" : zoning of urban planning documents,
\item "secteur-cc" : communal map sectors
\item "prescription-surf", "prescription-lin", "prescription-pct" : its's a constraint or a possibility indicated in an urban planning document (PLU, PLUi, ...)
\item "info-surf", "info-lin", "info-pct" : its's an information indicated in an urban planning document (PLU, PLUi, ...)
\item "acte-sup" : act establishing the SUP
\item "generateur-sup-s", "generateur-sup-l", "generateur-sup-p" : an entity (site or monument, watercourse, water catchment, electricity or gas distribution of electricity or gas, etc.) which generates on the surrounding SUP  (of passage, alignment, protection, land reservation, etc.)
\item "assiette-sup-s", "assiette-sup-l", "assiette-sup-p" : spatial area to which SUP it applies.
}
}
\examples{
\dontrun{
library(sf)

# find if commune is under the RNU (national urbanism regulation)
rnu <- get_apicarto_gpu("93014", "municipality")
rnu$is_rnu

# get urbanism document
x <- get_apicarto_cadastre("93014", "commune")
document <- get_apicarto_gpu(x, ressource = "document")
partition <- document$partition

# get gpu features
## from shape
gpu <- get_apicarto_gpu(x, ressource = "zone-urba")

## from partition
gpu <- get_apicarto_gpu("DU_93014", ressource = "zone-urba")

# example : all prescriptions
ressources <- c("prescription-surf",
                "prescription-lin",
                "prescription-pct")
prescriptions <- get_apicarto_gpu("DU_93014",
                                  ressource = ressources)

# example : public utility servitude (SUP) assiette
assiette_sup_s <- get_apicarto_gpu(x, ressource = "assiette-sup-s")
protection_forest <- get_apicarto_gpu(x,
                                      ressource = "assiette-sup-s",
                                      categorie = "A7")

# example : public utility servitude (SUP) generateur
## /!\ a generator can justify several assiette
ressources <- c("generateur-sup-p",
                "generateur-sup-l",
                "generateur-sup-s")
all_gen <- get_apicarto_gpu(x, ressource = ressources)

}
}
