% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sessions_info.R
\name{sessions_info}
\alias{sessions_info}
\alias{hansard_sessions_info}
\title{Parliamentary Session data}
\usage{
sessions_info(days = FALSE, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake", verbose = TRUE)

hansard_sessions_info(days = FALSE, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake", verbose = TRUE)
}
\arguments{
\item{days}{If \code{TRUE}, returns data for all available days. If
\code{FALSE}, returns data on each parliamentary session. If \code{TRUE}
and non-default \code{start_date} and/or \code{end_date} parameters are
requested, the function must retrieve all days and subset based on the
values passed to \code{start_date} and \code{end_date}. Not applicable
to \code{lords_sessions}. Defaults to \code{FALSE}.}

\item{start_date}{Only includes sessions starting on or after this date.
Accepts character values in \code{'YYYY-MM-DD'} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or anything
else that can be coerced to a date with \code{as.Date()}. Defaults to
\code{'1900-01-01'}.}

\item{end_date}{Only includes sessions ending on or before this date.
Accepts character values in \code{'YYYY-MM-DD'} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or
anything else that can be coerced to a date with \code{as.Date()}.
Defaults to the current system date.}

\item{extra_args}{Additional parameters and queries to pass to API. These
queries must be strings and start with "&". See the
\href{http://explore.data.parliament.uk/}{API documentation}
or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts any style accepted by \link[snakecase]{to_any_case}.
Defaults to \code{'snake'}.}

\item{verbose}{If \code{TRUE}, displayes messages on the console on the
progress of the API request. Defaults to \code{TRUE}.}
}
\value{
A tibble with details on parliamentary sessions.
}
\description{
Imports data on Parliamentary Sessions. Note that due to the date format
used by the API, if \code{days==TRUE} and the \code{end_date} and
\code{start_date} parameters are not set to the default values, the
function downloads all available data and then subsets the tibble
between the two given dates.
}
\examples{
\dontrun{
x <- sessions_info(days = TRUE)

y <- sessions_info(days = FALSE)
}

}
