% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epetition_tibble.R
\name{epetition_tibble}
\alias{epetition_tibble}
\alias{hansard_epetition_tibble}
\title{Bulk Epetition data}
\usage{
epetition_tibble(min_signatures = 1, max_signatures = NULL,
  status = NULL, start_date = "1900-01-01", end_date = Sys.Date(),
  extra_args = NULL, tidy = TRUE, tidy_style = "snake",
  verbose = TRUE)

hansard_epetition_tibble(min_signatures = 1, max_signatures = NULL,
  status = NULL, start_date = "1900-01-01", end_date = Sys.Date(),
  extra_args = NULL, tidy = TRUE, tidy_style = "snake",
  verbose = TRUE)
}
\arguments{
\item{min_signatures}{The minimum number of signatures required for
inclusion in the tibble. Defaults to 1.}

\item{max_signatures}{The maximum number of signatures required for
inclusion in the tibble. If \code{NULL}, there is no maximum number of
signatures. Defaults to \code{NULL}.}

\item{status}{The status of the petition, either \code{'open'} or
\code{'closed'}. If \code{NULL}, returns all petitions both open and
closed. Defaults to \code{NULL}.}

\item{start_date}{Only includes epetitions created on or after this date.
Accepts character values in \code{'YYYY-MM-DD'} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or
anything else that can be coerced to a date with \code{as.Date()}.
Defaults to \code{'1900-01-01'}.}

\item{end_date}{Only includes epetitions created on or before this date.
Accepts character values in \code{'YYYY-MM-DD'} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or a
nything else that can be coerced to a date with \code{as.Date()}.
Defaults to the current system date.}

\item{extra_args}{Additional parameters and queries to pass to API. These
queries must be strings and start with "&". See the
\href{http://explore.data.parliament.uk/}{API documentation}
or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts any style accepted by \link[snakecase]{to_any_case}.
Defaults to \code{'snake'}.}

\item{verbose}{If \code{TRUE}, displayes messages on the console on the
progress of the API request. Defaults to \code{TRUE}.}
}
\value{
A tibble with details on electronic petitions
submitted to parliament.
}
\description{
Get data on all epetitions submitted to parliament, with the label, sponsor,
number of signatures, date created and epetition ID. For greater detail on
indidivual epetitions, see \code{\link[=epetition]{epetition()}}.
}
\examples{
\dontrun{
x <- epetition_tibble()

y <- epetition_tibble(max_signatures = 500)

z <- epetition_tibble(start_date = "2016-12-01", end_date = "2017-04-25")
}

}
\seealso{
\code{\link[=epetition]{epetition()}}
}
