% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/early_day_motions.R
\name{early_day_motions}
\alias{early_day_motions}
\title{Imports data on early day motions}
\usage{
early_day_motions(edm_id = NULL, session = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), signatures = 1,
  extra_args = NULL, tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{edm_id}{Accepts the ID number of an early day motion, and returns data on that motion. Note that EDM numbers reset each parliamentary session, so using this as the only parameter will return multiple early day motions. Defaults to NULL.}

\item{session}{Accepts a parliamentary session, in 'yyyy/yy' format. Defaults to NULL.}

\item{start_date}{The earliest date to include in the tibble. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{end_date}{The latest date to include in the tibble. Defaults to current system date. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{signatures}{The minimum number of signatures required for inclusion in the tibble. Defaults to 1.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with details on the content, signatories and sponsors of all or a specified early day motions.
}
\description{
Imports data on early day motions
}
\examples{
\dontrun{

x <- early_day_motions(edm_id = 1073)

x <- early_day_motions(edm_id = 1073, session='2015/16')

}
}
\seealso{
\code{\link{mp_edms}}
}
\keyword{EDM}
\keyword{day}
\keyword{early}
\keyword{motion}
