% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_vote_record.R
\name{mp_vote_record}
\alias{mp_vote_record}
\title{mp_vote_record}
\usage{
mp_vote_record(mp_id = NULL, lobby = "all", start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE)
}
\arguments{
\item{mp_id}{The ID number of a member of the House of Commons.}

\item{lobby}{Accepts one of 'all', 'aye' or 'no'. 'aye' returns votes where the MP voted 'aye', 'no' returns votes where the MP voted 'no', 'all' returns all available votes by the MP. Defaults to 'all'.}

\item{start_date}{The earliest date to include in the data frame. Defaults to '1900-01-01'.}

\item{end_date}{The latest date to include in the data frame. Defaults to current system date.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the data frame to remove extra characters, superfluous text and convert variable names to snake_case. Defaults to TRUE.}
}
\description{
Accepts an ID number for a member of the House of Commons, and returns a data frame of their votes.
}
\examples{
\dontrun{
x <- mp_vote_record(172, lobby='all')

x <- mp_vote_record(172, lobby='aye')

x <- mp_vote_record(172, lobby='no')

# the extra_args parameter allows the inclusion of additional arguments or
# queries that are not available through the function's parameters
x <- mp_vote_record(172, extra_args = '&session=2016/17')


}
}
\keyword{divisions}
