% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\docType{data}
\name{HandlrClient}
\alias{HandlrClient}
\title{handlr client}
\arguments{
\item{x}{(character) a file path (the file must exist), a string
containing contents of the citation, a DOI, or a DOI as a URL.
See Details.}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
handlr client
}
\details{
\strong{Methods}
\itemize{
\item \code{read(format = NULL, ...)} - read input
\itemize{
\item \code{format}: one of citeproc, ris, bibtex, codemeta, or \code{NULL}. If \code{NULL},
we attempt to guess the format, and error if we can not guess
\item \code{...}: further args to the writer fxn, if any
}
\item \code{write(format, file = NULL, ...)} - write to std out or file
\itemize{
\item \code{format}: one of citeproc, ris, bibtex, rdfxml
\item \code{file}: a file path, if NULL to stdout. for \code{format=ris}, number of
files must equal number of ris citations
\item \code{...}: further args to the writer fxn, if any
\item Note: If \code{$parsed} is \code{NULL} then it's likely \code{$read()} has not
been run - in which case we attempt to run \code{$read()} to
populate \code{$parsed}
}
}

The various inputs to the \code{x} parameter are handled in different
ways:
\itemize{
\item file: contents read from file, we grab file extension, and we guess
format based on combination of contents and file extension because
file extensions may belie what's in the file
\item string: string read in, and we guess format based on contents of
the string
\item DOI: we request citeproc-json format from the Crossref API
\item DOI url: we request citeproc-json format from the Crossref API
}
}
\examples{
# read() can be run with format specified or not
# if format not given, we attempt to guess the format and then read
z <- system.file('extdata/citeproc.json', package = "handlr")
(x <- HandlrClient$new(x = z))
x$read()
x$read("citeproc")
x$parsed

# you can run read() then write()
# or just run write(), and read() will be run for you if possible
z <- system.file('extdata/citeproc.json', package = "handlr")
(x <- HandlrClient$new(x = z))
cat(x$write("ris"))

# read from a DOI as a url
if (interactive()) {
  (x <- HandlrClient$new('https://doi.org/10.7554/elife.01567'))
  x$parsed
  x$read()
  x$write('bibtex')
}

# read from a DOI
if (interactive()) {
  (x <- HandlrClient$new('10.7554/elife.01567'))
  x$parsed
  x$read()
  x$write('bibtex')
}

# read in citeproc, write out bibtex
z <- system.file('extdata/citeproc.json', package = "handlr")
(x <- HandlrClient$new(x = z))
x$path
x$ext
x$read("citeproc")
x$parsed
x$write("bibtex")
f <- tempfile(fileext = ".bib")
x$write("bibtex", file = f)
readLines(f)
unlink(f)

# read in ris, write out ris
z <- system.file('extdata/peerj.ris', package = "handlr")
(x <- HandlrClient$new(x = z))
x$path
x$format
x$read("ris")
x$parsed
x$write("ris")
cat(x$write("ris"))

# read in bibtex, write out ris
(z <- system.file('extdata/bibtex.bib', package = "handlr"))
(x <- HandlrClient$new(x = z))
x$path
x$format
x$read("bibtex")
x$parsed
x$write("ris")
cat(x$write("ris"))

# read in bibtex, write out RDF XML
if (interactive()) {
  (z <- system.file('extdata/bibtex.bib', package = "handlr"))
  (x <- HandlrClient$new(x = z))
  x$path
  x$format
  x$read("bibtex")
  x$parsed
  x$write("rdfxml")
  cat(x$write("rdfxml"))
}

# codemeta
(z <- system.file('extdata/codemeta.json', package = "handlr"))
(x <- HandlrClient$new(x = z))
x$path
x$format
x$read("codemeta")
x$parsed
x$write("codemeta")

# > 1
z <- system.file('extdata/citeproc-many.json', package = "handlr")
(x <- HandlrClient$new(x = z))
x$parsed
x$read()
x$parsed
## schmea org
x$write("schema_org")
## bibtex
x$write("bibtex")
## bibtex to file
f <- tempfile(fileext=".bib")
x$write("bibtex", f)
readLines(f)
unlink(f)
## to RIS
x$write("ris")
### only one per file, so not combined
files <- replicate(2, tempfile(fileext=".ris"))
x$write("ris", files)
lapply(files, readLines)

# handle strings instead of files
z <- system.file('extdata/citeproc-crossref.json', package = "handlr")
(x <- HandlrClient$new(x = readLines(z)))
x$read("citeproc")
x$parsed
cat(x$write("bibtex"), sep = "\\n")
}
\keyword{datasets}
