% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{map_hazard_to_density}
\alias{map_hazard_to_density}
\title{Map a predicted hazard to a predicted density for a single observation}
\usage{
map_hazard_to_density(hazard_pred_single_obs)
}
\arguments{
\item{hazard_pred_single_obs}{A \code{numeric} vector of predicted hazard of
failure in a given bin (under a given partitioning of the support) for a
single observational unit based on a long format data structure (from
\code{\link{format_long_hazards}}). This is the probability that a given
value falls in a corresponding bin, given that it has not yet failed
(fallen in a preceding bin), as per \insertRef{diaz2011super}{haldensify}.}
}
\value{
A \code{matrix} composed of a single row and a number of columns
 specified by the grid of penalization parameters used in fitting of the
 highly adaptive lasso. This is the predicted conditional density for a
 given observation, re-mapped from the hazard scale.
}
\description{
Map a predicted hazard to a predicted density for a single observation
}
\details{
For a single observation, map a predicted hazard of failure (as an
 occurrence in a particular bin, under a given partitioning of the support)
 to a density.
}
