% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tikzutils.R
\name{tikz.init}
\alias{tikz.init}
\title{tikz.init}
\usage{
tikz.init(basename, standAlone = TRUE, engine, ...)
}
\arguments{
\item{basename}{the base of the files which will be used by
\code{tikzDevice}, e.g. "basename" -> "basename.pdf", etc.}

\item{standAlone}{A logical value indicating whether the output file should
be suitable for direct processing by LaTeX. A value of \code{FALSE}
indicates that the file is intended for inclusion in a larger document.}

\item{engine}{used to specify the LaTex engine. If missing, the standard
engine of tikz is used.}

\item{...}{optional arguments which are passed to \code{tikz}, see
\code{\link[tikzDevice:tikz]{tikzDevice::tikz}}}
}
\value{
\code{tikz.init} returns a list with character vector members, $pdf,
$tex, $aux $log containing the corresponding filenames
}
\description{
initialize and finalize a \code{tikzDevice} and carry out optional
post-processing
}
\details{
Convenience Functions for \code{tikzDevice}
}
\examples{

\donttest{tikzfiles <- tikz.init("plotname",width=3,height=4)}
\donttest{plot(x=c(1:3), y=c(1:3)^2, xlab="$x$", ylab="$y$")}
\donttest{tikz.finalize(tikzfiles=tikzfiles, clean=TRUE)}
\donttest{file.remove("plotname.pdf")}

}
\seealso{
Other tikzutils: 
\code{\link{tikz.finalize}()}
}
\author{
Bartosz Kostrzewa, \email{bartosz.kostrzewa@desy.de}
}
\concept{tikzutils}
\keyword{file}
