% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{resampling_is_compatible}
\alias{resampling_is_compatible}
\title{Checks whether the resampling of two cf objects is compatible}
\usage{
resampling_is_compatible(cf1, cf2)
}
\arguments{
\item{cf1}{\code{cf} object with \code{cf_boot}}

\item{cf2}{\code{cf} object with \code{cf_boot}}
}
\value{
List of named booleans for each of the checked conditions
with elements \code{boot}, \code{boot.R}, \code{boot.l}, \code{sim}, \code{endcorr},
\code{resampling_method}, \code{boot_dim}, \code{icf} and, optionally
\code{iboot_dim} (if both \code{cf1} and \code{cf2} contain imaginary parts).
}
\description{
Checks whether the resampling of two cf objects is compatible
}
\details{
Checks whether operations such as addition can be performed on the
resampling samples of \code{cf1} and \code{cf2}. In addition to all
meta parameters, the dimensions of the resampling sample arrays
must be identical.
}
