% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5utils.R
\name{h5_names_exist}
\alias{h5_names_exist}
\title{check if group names exist in HDF5 file}
\usage{
h5_names_exist(h5f, nms_to_find)
}
\arguments{
\item{h5f}{HDF5 file handle openend with \code{rhdf5::H5Fopen}}

\item{nms_to_find}{Vector of strings, group names (not full paths) which
are to be located in the file.}
}
\value{
Vector of booleans of the same length as \code{nms_to_find}
indicating whether the name at the same index position
was located in the file.
}
\description{
The group names in an HDF5 file are stored as full paths
as well as a flat vector. It is thus possible to check
if a particular set of group names exist in the file
by parsing the \code{name} member of the output
of \code{rhdf5::h5ls}. This function does just that.
}
