% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hankel.R
\name{gevp.hankel}
\alias{gevp.hankel}
\title{GEVP method based on Hankel matrices.}
\usage{
gevp.hankel(cf, t0 = 1, deltat = 1, n, N, submatrix.size = 1,
  element.order = c(1, 2, 3, 4), Delta = 1)
}
\arguments{
\item{cf}{Numeric vector (this will generally be the time slices of a correlation function).}

\item{t0}{Integer. Initial time value of the GEVP, must be in between 0 and
\code{Time/2-2}. Default is 1.}

\item{deltat}{Integer. Time shift to be used to build the Hankel matrix}

\item{n}{Integer. Size of the Hankel matrices to generate}

\item{N}{Integer. Maximal time index in correlation function to be used in
Hankel matrix}

\item{submatrix.size}{Integer. Submatrix size to be used in build
of Hankel matrices. Submatrix.size > 1 is experimental.}

\item{element.order}{Integer vector. specifies how to fit the \code{n} linearly ordered single
correlators into the correlator
matrix for submatrix.size > 1. \code{element.order=c(1,2,3,4)} leads to a matrix
\code{matrix(cf[element.order], nrow=2)}.
Matrix elements can occur multiple times, such as \code{c(1,2,2,3)} for the symmetric case,
for example.}

\item{Delta}{integer. Delta is the time shift used in the Hankel matrix.}
}
\value{
A complex vector of length \code{n + n^2} which contains the eigenvalues in the first
\code{n} elements and the eigenvectors in the remaining \code{n^2} elements.

A vector of NAs of \code{n + n^2} is returend in case the QR decomposition fails.
}
\description{
Alternative method to determine energy levels from correlation
matrices. A so-called Hankel matrix is generated from an input
real numeric vector and a generalised eigenvalue problem is solved
then.
}
\seealso{
Other hankel: 
\code{\link{bootstrap.hankel_summed}()},
\code{\link{bootstrap.hankel}()},
\code{\link{gevp.hankel_summed}()},
\code{\link{hankel2cf}()},
\code{\link{hankel2effectivemass}()},
\code{\link{plot_hankel_spectrum}()}
}
\concept{hankel}
