% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{cf_orig}
\alias{cf_orig}
\title{Original data CF mixin constructor}
\usage{
cf_orig(.cf = cf(), cf, icf = NULL)
}
\arguments{
\item{.cf}{\code{cf} object to extend. Named with a leading period just to distinguish it from the member also named \code{cf}.}

\item{cf}{Numeric matrix, original data for all observables and measurements.}

\item{icf}{Numeric matrix, imaginary part of original data. Be very careful with this as quite a few functions just ignore the imaginary part and drop it in operations.}
}
\value{
returns the input object of class \code{cf} with the original data mixin added
}
\description{
Original data CF mixin constructor
}
\examples{

newcf <- cf_orig(cf=array(rnorm(25*100), dim=c(100, 25))) 
newcf <- cf_meta(newcf, nrObs=1, Time=48, symmetrised=TRUE)
newcf <- bootstrap.cf(newcf)
plot(newcf)

}
\seealso{
Other cf constructors: 
\code{\link{cf_boot}()},
\code{\link{cf_meta}()},
\code{\link{cf_principal_correlator}()},
\code{\link{cf_shifted}()},
\code{\link{cf_smeared}()},
\code{\link{cf_subtracted}()},
\code{\link{cf_weighted}()},
\code{\link{cf}()}
}
\concept{cf constructors}
