% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hablar.R
\name{rationalize}
\alias{rationalize}
\alias{rationalize.default}
\alias{rationalize.numeric}
\alias{rationalize.data.frame}
\title{Only allow rational values in numeric vectors

\code{rationalize} transforms all numeric elements to be rational values or NA,
thus removes all \code{NaN,Inf} and replaces them with \code{NA}.}
\usage{
rationalize(.x, ...)

\method{rationalize}{default}(.x, ...)

\method{rationalize}{numeric}(.x, ...)

\method{rationalize}{data.frame}(.x, ...)
}
\arguments{
\item{.x}{vector or data.frame}

\item{...}{columns to be evaluated. Only applicable if .x is a data frame.}
}
\value{
For vectors: same data type/class as .x.

For data.frame: a tbl data frame.

\code{NULL}

\code{NULL}

\code{NULL}
}
\description{
Only allow rational values in numeric vectors

\code{rationalize} transforms all numeric elements to be rational values or NA,
thus removes all \code{NaN,Inf} and replaces them with \code{NA}.
}
\details{
#' If a non-numeric vector is passed, it is unchanged. If a data.frame is
passed, it evaluates all columns separately.
}
\examples{
x <- c(3, -Inf, 6.56, 9.3, NaN, 5, -Inf)
rationalize(x)

df <- data.frame(num_col = c(Inf, 3, NaN), 
                 chr_col = c("a", "b", "c"), 
                 stringsAsFactors = FALSE)
df
rationalize(df)

}
\seealso{
\code{\link{s}}, \code{\link{rationalize}}
}
