% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.hIRT}
\alias{coef.hIRT}
\alias{coef_mean}
\alias{coef_var}
\title{Extracting Parameter Estimates from Hierarchical IRT Models.}
\usage{
\method{coef}{hIRT}(object, digits = 3, ...)

coef_mean(x, digits = 3)

coef_var(x, digits = 3)
}
\arguments{
\item{object}{An object of class \code{hIRT}}

\item{digits}{The number of significant digits to use when printing}

\item{...}{further arguments passed to or from other methods}

\item{x}{An object of class \code{hIRT}}
}
\value{
A data frame of parameter estimates, standard errors, z values and p values.
}
\description{
Parameter estimates from either \code{hltm} or \code{hgrm} models. \code{coef_mean}
reports results only for the mean equation. \code{coef_var} reports results only for
the variance equation.
}
\examples{
y <- nes_econ2008[, -(1:3)]
x <- model.matrix( ~ party * educ, nes_econ2008)
z <- model.matrix( ~ party, nes_econ2008)
nes_m1 <- hgrm(y, x, z)
coef(nes_m1)
coef_mean(nes_m1)
coef_var(nes_m1)
}
