% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gng_m2.R
\name{gng_m2}
\alias{gng_m2}
\title{Orthogonalized Go/Nogo Task}
\usage{
gng_m2(data = "choose", niter = 4000, nwarmup = 1000, nchain = 4,
  ncore = 1, nthin = 1, inits = "random", indPars = "mean",
  modelRegressor = FALSE, vb = FALSE, inc_postpred = FALSE,
  adapt_delta = 0.95, stepsize = 1, max_treedepth = 10, ...)
}
\arguments{
\item{data}{A .txt file containing the data to be modeled. Data columns should be labeled as:
"subjID", "cue", "keyPressed", "outcome". See \bold{Details} below for more information.}

\item{niter}{Number of iterations, including warm-up. Defaults to 4000.}

\item{nwarmup}{Number of iterations used for warm-up only. Defaults to 1000.}

\item{nchain}{Number of Markov chains to run. Defaults to 4.}

\item{ncore}{Number of CPUs to be used for running. Defaults to 1.}

\item{nthin}{Every \code{i == nthin} sample will be used to generate the posterior distribution.
Defaults to 1. A higher number can be used when auto-correlation within the MCMC sampling is
high.}

\item{inits}{Character value specifying how the initial values should be generated. Options are
"fixed" or "random", or your own initial values.}

\item{indPars}{Character value specifying how to summarize individual parameters. Current options
are: "mean", "median", or "mode".}

\item{modelRegressor}{Export model-based regressors? TRUE or FALSE.
For this model they are: "Qgo", "Qnogo", "Wgo", "Wnogo".}

\item{vb}{Use variational inference to approximately draw from a posterior distribution. Defaults
to FALSE.}

\item{inc_postpred}{Include trial-level posterior predictive simulations in model output (may greatly increase file
size). Defaults to FALSE.}

\item{adapt_delta}{Floating point value representing the target acceptance probability of a new
sample in the MCMC chain. Must be between 0 and 1. See \bold{Details} below.}

\item{stepsize}{Integer value specifying the size of each leapfrog step that the MCMC sampler can
take on each new iteration. See \bold{Details} below.}

\item{max_treedepth}{Integer value specifying how many leapfrog steps the MCMC sampler can take
on each new iteration. See \bold{Details} below.}

\item{...}{Not used for this model.}
}
\value{
A class "hBayesDM" object \code{modelData} with the following components:
\describe{
  \item{\code{model}}{Character value that is the name of the model ("gng_m2").}
  \item{\code{allIndPars}}{Data.frame containing the summarized parameter values (as specified by
    \code{indPars}) for each subject.}
  \item{\code{parVals}}{List object containing the posterior samples over different parameters.}
  \item{\code{fit}}{A class \code{\link[rstan]{stanfit}} object that contains the fitted Stan
    model.}
  \item{\code{rawdata}}{Data.frame containing the raw data used to fit the model, as specified by
    the user.}
  
  
  \item{\code{modelRegressor}}{List object containing the extracted model-based regressors.}
}
}
\description{
Hierarchical Bayesian Modeling of the Orthogonalized Go/Nogo Task with the following parameters:
  "xi" (noise), "ep" (learning rate), "b" (action bias), "rho" (effective size).

\strong{MODEL:} RW + noise + bias (Guitart-Masip et al., 2012, Neuroimage)
}
\details{
This section describes some of the function arguments in greater detail.

\strong{data} should be assigned a character value specifying the full path and name (including
  extension information, e.g. ".txt") of the file that contains the behavioral data-set of all
  subjects of interest for the current analysis. The file should be a \strong{tab-delimited} text
  file, whose rows represent trial-by-trial observations and columns represent variables.\cr
For the Orthogonalized Go/Nogo Task, there should be 4 columns of data with the
  labels "subjID", "cue", "keyPressed", "outcome". It is not necessary for the columns to be in this particular order,
  however it is necessary that they be labeled correctly and contain the information below:
\describe{
  \item{"subjID"}{A unique identifier for each subject in the data-set.}
  \item{"cue"}{Nominal integer representing the cue shown for that trial: 1, 2, 3, or 4.}
  \item{"keyPressed"}{Binary value representing the subject's response for that trial (where Press == 1; No press == 0).}
  \item{"outcome"}{Ternary value representing the outcome of that trial (where Positive feedback == 1; Neutral feedback == 0; Negative feedback == -1).}
  
  
  
  
  
}
\strong{*}Note: The file may contain other columns of data (e.g. "ReactionTime", "trial_number",
  etc.), but only the data within the column names listed above will be used during the modeling.
  As long as the necessary columns mentioned above are present and labeled correctly, there is no
  need to remove other miscellaneous data columns.

\strong{nwarmup} is a numerical value that specifies how many MCMC samples should not be stored
  upon the beginning of each chain. For those familiar with Bayesian methods, this is equivalent
  to burn-in samples. Due to the nature of the MCMC algorithm, initial values (i.e. where the
  sampling chains begin) can have a heavy influence on the generated posterior distributions. The
  \code{nwarmup} argument can be set to a high number in order to curb the effects that initial
  values have on the resulting posteriors.

\strong{nchain} is a numerical value that specifies how many chains (i.e. independent sampling
  sequences) should be used to draw samples from the posterior distribution. Since the posteriors
  are generated from a sampling process, it is good practice to run multiple chains to ensure
  that a reasonably representative posterior is attained. When the sampling is complete, it is
  possible to check the multiple chains for convergence by running the following line of code:
  \code{plot(output, type = "trace")}. The trace-plot should resemble a "furry caterpillar".

\strong{nthin} is a numerical value that specifies the "skipping" behavior of the MCMC sampler,
  using only every \code{i == nthin} samples to generate posterior distributions. By default,
  \code{nthin} is equal to 1, meaning that every sample is used to generate the posterior.

\strong{Control Parameters:} \code{adapt_delta}, \code{stepsize}, and \code{max_treedepth} are
  advanced options that give the user more control over Stan's MCMC sampler. It is recommended
  that only advanced users change the default values, as alterations can profoundly change the
  sampler's behavior. Refer to 'The No-U-Turn Sampler: Adaptively Setting Path Lengths in
  Hamiltonian Monte Carlo (Hoffman & Gelman, 2014, Journal of Machine Learning Research)' for
  more information on the sampler control parameters. One can also refer to 'Section 34.2. HMC
  Algorithm Parameters' of the \href{http://mc-stan.org/users/documentation/}{Stan User's Guide
  and Reference Manual}, or to the help page for \code{\link[rstan]{stan}} for a less technical
  description of these arguments.
}
\examples{
\dontrun{
# Run the model and store results in "output"
output <- gng_m2("example", niter = 2000, nwarmup = 1000, nchain = 4, ncore = 4)

# Visually check convergence of the sampling chains (should look like 'hairy caterpillars')
plot(output, type = "trace")

# Check Rhat values (all Rhat values should be less than or equal to 1.1)
rhat(output)

# Plot the posterior distributions of the hyper-parameters (distributions should be unimodal)
plot(output)

# Show the WAIC and LOOIC model fit estimates
printFit(output)
}
}
\references{
Guitart-Masip, M., Huys, Q. J. M., Fuentemilla, L., Dayan, P., Duzel, E., & Dolan, R. J. (2012).
  Go and no-go learning in reward and punishment: Interactions between affect and effect.
  Neuroimage, 62(1), 154-166. http://doi.org/10.1016/j.neuroimage.2012.04.024
}
\seealso{
We refer users to our in-depth tutorial for an example of using hBayesDM:
  \url{https://rpubs.com/CCSL/hBayesDM}
}
