/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_ug_bayes_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_ug_bayes");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_ug_bayes");
    reader.add_event(181, 166, "end", "model_ug_bayes");
    return reader;
}

#include <meta_header.hpp>
 class model_ug_bayes : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > offer;
    vector<vector<int> > accept;
    double initV;
    double mu0;
    double k0;
    double sig20;
    double nu0;
public:
    model_ug_bayes(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_ug_bayes(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_ug_bayes_namespace::model_ug_bayes";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 19;
            validate_non_negative_index("Tsubj", "N", N);
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
            validate_non_negative_index("Tsubj", "N", N);
            Tsubj = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            size_t Tsubj_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
                Tsubj[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 20;
            validate_non_negative_index("offer", "N", N);
            validate_non_negative_index("offer", "T", T);
            context__.validate_dims("data initialization", "offer", "double", context__.to_vec(N,T));
            validate_non_negative_index("offer", "N", N);
            validate_non_negative_index("offer", "T", T);
            offer = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("offer");
            pos__ = 0;
            size_t offer_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < offer_limit_1__; ++i_1__) {
                size_t offer_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < offer_limit_0__; ++i_0__) {
                    offer[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 21;
            validate_non_negative_index("accept", "N", N);
            validate_non_negative_index("accept", "T", T);
            context__.validate_dims("data initialization", "accept", "int", context__.to_vec(N,T));
            validate_non_negative_index("accept", "N", N);
            validate_non_negative_index("accept", "T", T);
            accept = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("accept");
            pos__ = 0;
            size_t accept_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < accept_limit_1__; ++i_1__) {
                size_t accept_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < accept_limit_0__; ++i_0__) {
                    accept[i_0__][i_1__] = vals_i__[pos__++];
                }
            }

            // validate, data variables
            current_statement_begin__ = 17;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 18;
            check_greater_or_equal(function__,"T",T,1);
            current_statement_begin__ = 19;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
                check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
            }
            current_statement_begin__ = 20;
            current_statement_begin__ = 21;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"accept[k0__][k1__]",accept[k0__][k1__],-(1));
                    check_less_or_equal(function__,"accept[k0__][k1__]",accept[k0__][k1__],1);
                }
            }
            // initialize data variables
            current_statement_begin__ = 25;
            initV = double(0);
            stan::math::fill(initV,DUMMY_VAR__);
            current_statement_begin__ = 26;
            mu0 = double(0);
            stan::math::fill(mu0,DUMMY_VAR__);
            current_statement_begin__ = 27;
            k0 = double(0);
            stan::math::fill(k0,DUMMY_VAR__);
            current_statement_begin__ = 28;
            sig20 = double(0);
            stan::math::fill(sig20,DUMMY_VAR__);
            current_statement_begin__ = 29;
            nu0 = double(0);
            stan::math::fill(nu0,DUMMY_VAR__);

            current_statement_begin__ = 31;
            stan::math::assign(initV, 0.0);
            current_statement_begin__ = 32;
            stan::math::assign(mu0, 10.0);
            current_statement_begin__ = 33;
            stan::math::assign(k0, 4.0);
            current_statement_begin__ = 34;
            stan::math::assign(sig20, 4.0);
            current_statement_begin__ = 35;
            stan::math::assign(nu0, 10.0);

            // validate transformed data
            current_statement_begin__ = 25;
            current_statement_begin__ = 26;
            current_statement_begin__ = 27;
            current_statement_begin__ = 28;
            current_statement_begin__ = 29;

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 41;
            validate_non_negative_index("mu_pr", "3", 3);
            num_params_r__ += 3;
            current_statement_begin__ = 42;
            validate_non_negative_index("sigma", "3", 3);
            num_params_r__ += 3;
            current_statement_begin__ = 45;
            validate_non_negative_index("alpha_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 46;
            validate_non_negative_index("beta_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 47;
            validate_non_negative_index("tau_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_ug_bayes() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "3", 3);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(3));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "3", 3);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("alpha_pr")))
            throw std::runtime_error("variable alpha_pr missing");
        vals_r__ = context__.vals_r("alpha_pr");
        pos__ = 0U;
        validate_non_negative_index("alpha_pr", "N", N);
        context__.validate_dims("initialization", "alpha_pr", "vector_d", context__.to_vec(N));
        vector_d alpha_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            alpha_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_pr: ") + e.what());
        }

        if (!(context__.contains_r("beta_pr")))
            throw std::runtime_error("variable beta_pr missing");
        vals_r__ = context__.vals_r("beta_pr");
        pos__ = 0U;
        validate_non_negative_index("beta_pr", "N", N);
        context__.validate_dims("initialization", "beta_pr", "vector_d", context__.to_vec(N));
        vector_d beta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            beta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_pr: ") + e.what());
        }

        if (!(context__.contains_r("tau_pr")))
            throw std::runtime_error("variable tau_pr missing");
        vals_r__ = context__.vals_r("tau_pr");
        pos__ = 0U;
        validate_non_negative_index("tau_pr", "N", N);
        context__.validate_dims("initialization", "tau_pr", "vector_d", context__.to_vec(N));
        vector_d tau_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            tau_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(tau_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(3,lp__);
            else
                mu_pr = in__.vector_constrain(3);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,3,lp__);
            else
                sigma = in__.vector_lb_constrain(0,3);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha_pr;
            (void) alpha_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha_pr = in__.vector_constrain(N,lp__);
            else
                alpha_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta_pr;
            (void) beta_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_pr = in__.vector_constrain(N,lp__);
            else
                beta_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tau_pr;
            (void) tau_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                tau_pr = in__.vector_constrain(N,lp__);
            else
                tau_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 52;
            validate_non_negative_index("alpha", "N", N);
            vector<local_scalar_t__> alpha(N);
            stan::math::initialize(alpha, DUMMY_VAR__);
            stan::math::fill(alpha,DUMMY_VAR__);
            current_statement_begin__ = 53;
            validate_non_negative_index("beta", "N", N);
            vector<local_scalar_t__> beta(N);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta,DUMMY_VAR__);
            current_statement_begin__ = 54;
            validate_non_negative_index("tau", "N", N);
            vector<local_scalar_t__> tau(N);
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau,DUMMY_VAR__);


            current_statement_begin__ = 56;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 57;
                stan::model::assign(alpha, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 20), 
                            "assigning variable alpha");
                current_statement_begin__ = 58;
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 10), 
                            "assigning variable beta");
                current_statement_begin__ = 59;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,3,"mu_pr",1) + (get_base1(sigma,3,"sigma",1) * get_base1(tau_pr,i,"tau_pr",1)))) * 10), 
                            "assigning variable tau");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(alpha[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: alpha" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(beta[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(tau[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tau" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 52;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"alpha[k0__]",alpha[k0__],0);
                check_less_or_equal(function__,"alpha[k0__]",alpha[k0__],20);
            }
            current_statement_begin__ = 53;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"beta[k0__]",beta[k0__],0);
                check_less_or_equal(function__,"beta[k0__]",beta[k0__],10);
            }
            current_statement_begin__ = 54;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"tau[k0__]",tau[k0__],0);
                check_less_or_equal(function__,"tau[k0__]",tau[k0__],10);
            }

            // model body

            current_statement_begin__ = 65;
            lp_accum__.add(normal_log<propto__>(mu_pr, 0, 1));
            current_statement_begin__ = 66;
            lp_accum__.add(normal_log<propto__>(sigma, 0, 0.20000000000000001));
            current_statement_begin__ = 69;
            lp_accum__.add(normal_log<propto__>(alpha_pr, 0, 1.0));
            current_statement_begin__ = 70;
            lp_accum__.add(normal_log<propto__>(beta_pr, 0, 1.0));
            current_statement_begin__ = 71;
            lp_accum__.add(normal_log<propto__>(tau_pr, 0, 1.0));
            current_statement_begin__ = 73;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 75;
                local_scalar_t__ util;
                (void) util;  // dummy to suppress unused var warning

                stan::math::initialize(util, DUMMY_VAR__);
                stan::math::fill(util,DUMMY_VAR__);
                current_statement_begin__ = 76;
                local_scalar_t__ mu_old;
                (void) mu_old;  // dummy to suppress unused var warning

                stan::math::initialize(mu_old, DUMMY_VAR__);
                stan::math::fill(mu_old,DUMMY_VAR__);
                current_statement_begin__ = 77;
                local_scalar_t__ mu_new;
                (void) mu_new;  // dummy to suppress unused var warning

                stan::math::initialize(mu_new, DUMMY_VAR__);
                stan::math::fill(mu_new,DUMMY_VAR__);
                current_statement_begin__ = 78;
                local_scalar_t__ k_old;
                (void) k_old;  // dummy to suppress unused var warning

                stan::math::initialize(k_old, DUMMY_VAR__);
                stan::math::fill(k_old,DUMMY_VAR__);
                current_statement_begin__ = 79;
                local_scalar_t__ k_new;
                (void) k_new;  // dummy to suppress unused var warning

                stan::math::initialize(k_new, DUMMY_VAR__);
                stan::math::fill(k_new,DUMMY_VAR__);
                current_statement_begin__ = 80;
                local_scalar_t__ sig2_old;
                (void) sig2_old;  // dummy to suppress unused var warning

                stan::math::initialize(sig2_old, DUMMY_VAR__);
                stan::math::fill(sig2_old,DUMMY_VAR__);
                current_statement_begin__ = 81;
                local_scalar_t__ sig2_new;
                (void) sig2_new;  // dummy to suppress unused var warning

                stan::math::initialize(sig2_new, DUMMY_VAR__);
                stan::math::fill(sig2_new,DUMMY_VAR__);
                current_statement_begin__ = 82;
                local_scalar_t__ nu_old;
                (void) nu_old;  // dummy to suppress unused var warning

                stan::math::initialize(nu_old, DUMMY_VAR__);
                stan::math::fill(nu_old,DUMMY_VAR__);
                current_statement_begin__ = 83;
                local_scalar_t__ nu_new;
                (void) nu_new;  // dummy to suppress unused var warning

                stan::math::initialize(nu_new, DUMMY_VAR__);
                stan::math::fill(nu_new,DUMMY_VAR__);
                current_statement_begin__ = 84;
                local_scalar_t__ PE;
                (void) PE;  // dummy to suppress unused var warning

                stan::math::initialize(PE, DUMMY_VAR__);
                stan::math::fill(PE,DUMMY_VAR__);


                current_statement_begin__ = 87;
                stan::math::assign(mu_old, mu0);
                current_statement_begin__ = 88;
                stan::math::assign(k_old, k0);
                current_statement_begin__ = 89;
                stan::math::assign(sig2_old, sig20);
                current_statement_begin__ = 90;
                stan::math::assign(nu_old, nu0);
                current_statement_begin__ = 92;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 93;
                    stan::math::assign(k_new, (k_old + 1));
                    current_statement_begin__ = 94;
                    stan::math::assign(nu_new, (nu_old + 1));
                    current_statement_begin__ = 95;
                    stan::math::assign(mu_new, (((k_old / k_new) * mu_old) + ((1 / k_new) * get_base1(get_base1(offer,i,"offer",1),t,"offer",2))));
                    current_statement_begin__ = 96;
                    stan::math::assign(sig2_new, (((nu_old / nu_new) * sig2_old) + (((1 / nu_new) * (k_old / k_new)) * pow((get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - mu_old),2))));
                    current_statement_begin__ = 98;
                    stan::math::assign(PE, (get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - mu_old));
                    current_statement_begin__ = 99;
                    stan::math::assign(util, ((get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - (get_base1(alpha,i,"alpha",1) * stan::math::fmax((mu_new - get_base1(get_base1(offer,i,"offer",1),t,"offer",2)),0.0))) - (get_base1(beta,i,"beta",1) * stan::math::fmax((get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - mu_new),0.0))));
                    current_statement_begin__ = 101;
                    lp_accum__.add(bernoulli_logit_log<propto__>(get_base1(get_base1(accept,i,"accept",1),t,"accept",2), (util * get_base1(tau,i,"tau",1))));
                    current_statement_begin__ = 104;
                    stan::math::assign(mu_old, mu_new);
                    current_statement_begin__ = 105;
                    stan::math::assign(sig2_old, sig2_new);
                    current_statement_begin__ = 106;
                    stan::math::assign(k_old, k_new);
                    current_statement_begin__ = 107;
                    stan::math::assign(nu_old, nu_new);
                }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("alpha_pr");
        names__.push_back("beta_pr");
        names__.push_back("tau_pr");
        names__.push_back("alpha");
        names__.push_back("beta");
        names__.push_back("tau");
        names__.push_back("mu_alpha");
        names__.push_back("mu_beta");
        names__.push_back("mu_tau");
        names__.push_back("log_lik");
        names__.push_back("y_pred");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_ug_bayes_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d alpha_pr = in__.vector_constrain(N);
        vector_d beta_pr = in__.vector_constrain(N);
        vector_d tau_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 52;
            validate_non_negative_index("alpha", "N", N);
            vector<local_scalar_t__> alpha(N);
            stan::math::initialize(alpha, DUMMY_VAR__);
            stan::math::fill(alpha,DUMMY_VAR__);
            current_statement_begin__ = 53;
            validate_non_negative_index("beta", "N", N);
            vector<local_scalar_t__> beta(N);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta,DUMMY_VAR__);
            current_statement_begin__ = 54;
            validate_non_negative_index("tau", "N", N);
            vector<local_scalar_t__> tau(N);
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau,DUMMY_VAR__);


            current_statement_begin__ = 56;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 57;
                stan::model::assign(alpha, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 20), 
                            "assigning variable alpha");
                current_statement_begin__ = 58;
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 10), 
                            "assigning variable beta");
                current_statement_begin__ = 59;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,3,"mu_pr",1) + (get_base1(sigma,3,"sigma",1) * get_base1(tau_pr,i,"tau_pr",1)))) * 10), 
                            "assigning variable tau");
            }

            // validate transformed parameters
            current_statement_begin__ = 52;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"alpha[k0__]",alpha[k0__],0);
                check_less_or_equal(function__,"alpha[k0__]",alpha[k0__],20);
            }
            current_statement_begin__ = 53;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"beta[k0__]",beta[k0__],0);
                check_less_or_equal(function__,"beta[k0__]",beta[k0__],10);
            }
            current_statement_begin__ = 54;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"tau[k0__]",tau[k0__],0);
                check_less_or_equal(function__,"tau[k0__]",tau[k0__],10);
            }

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 114;
            local_scalar_t__ mu_alpha;
            (void) mu_alpha;  // dummy to suppress unused var warning

            stan::math::initialize(mu_alpha, DUMMY_VAR__);
            stan::math::fill(mu_alpha,DUMMY_VAR__);
            current_statement_begin__ = 115;
            local_scalar_t__ mu_beta;
            (void) mu_beta;  // dummy to suppress unused var warning

            stan::math::initialize(mu_beta, DUMMY_VAR__);
            stan::math::fill(mu_beta,DUMMY_VAR__);
            current_statement_begin__ = 116;
            local_scalar_t__ mu_tau;
            (void) mu_tau;  // dummy to suppress unused var warning

            stan::math::initialize(mu_tau, DUMMY_VAR__);
            stan::math::fill(mu_tau,DUMMY_VAR__);
            current_statement_begin__ = 119;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            current_statement_begin__ = 122;
            validate_non_negative_index("y_pred", "N", N);
            validate_non_negative_index("y_pred", "T", T);
            vector<vector<local_scalar_t__> > y_pred(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(y_pred, DUMMY_VAR__);
            stan::math::fill(y_pred,DUMMY_VAR__);


            current_statement_begin__ = 125;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 126;
                for (int t = 1; t <= T; ++t) {

                    current_statement_begin__ = 127;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                -(1), 
                                "assigning variable y_pred");
                }
            }
            current_statement_begin__ = 131;
            stan::math::assign(mu_alpha, (Phi_approx(get_base1(mu_pr,1,"mu_pr",1)) * 20));
            current_statement_begin__ = 132;
            stan::math::assign(mu_beta, (Phi_approx(get_base1(mu_pr,2,"mu_pr",1)) * 10));
            current_statement_begin__ = 133;
            stan::math::assign(mu_tau, (Phi_approx(get_base1(mu_pr,3,"mu_pr",1)) * 10));

            current_statement_begin__ = 136;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 138;
                local_scalar_t__ util;
                (void) util;  // dummy to suppress unused var warning

                stan::math::initialize(util, DUMMY_VAR__);
                stan::math::fill(util,DUMMY_VAR__);
                current_statement_begin__ = 139;
                local_scalar_t__ mu_old;
                (void) mu_old;  // dummy to suppress unused var warning

                stan::math::initialize(mu_old, DUMMY_VAR__);
                stan::math::fill(mu_old,DUMMY_VAR__);
                current_statement_begin__ = 140;
                local_scalar_t__ mu_new;
                (void) mu_new;  // dummy to suppress unused var warning

                stan::math::initialize(mu_new, DUMMY_VAR__);
                stan::math::fill(mu_new,DUMMY_VAR__);
                current_statement_begin__ = 141;
                local_scalar_t__ k_old;
                (void) k_old;  // dummy to suppress unused var warning

                stan::math::initialize(k_old, DUMMY_VAR__);
                stan::math::fill(k_old,DUMMY_VAR__);
                current_statement_begin__ = 142;
                local_scalar_t__ k_new;
                (void) k_new;  // dummy to suppress unused var warning

                stan::math::initialize(k_new, DUMMY_VAR__);
                stan::math::fill(k_new,DUMMY_VAR__);
                current_statement_begin__ = 143;
                local_scalar_t__ sig2_old;
                (void) sig2_old;  // dummy to suppress unused var warning

                stan::math::initialize(sig2_old, DUMMY_VAR__);
                stan::math::fill(sig2_old,DUMMY_VAR__);
                current_statement_begin__ = 144;
                local_scalar_t__ sig2_new;
                (void) sig2_new;  // dummy to suppress unused var warning

                stan::math::initialize(sig2_new, DUMMY_VAR__);
                stan::math::fill(sig2_new,DUMMY_VAR__);
                current_statement_begin__ = 145;
                local_scalar_t__ nu_old;
                (void) nu_old;  // dummy to suppress unused var warning

                stan::math::initialize(nu_old, DUMMY_VAR__);
                stan::math::fill(nu_old,DUMMY_VAR__);
                current_statement_begin__ = 146;
                local_scalar_t__ nu_new;
                (void) nu_new;  // dummy to suppress unused var warning

                stan::math::initialize(nu_new, DUMMY_VAR__);
                stan::math::fill(nu_new,DUMMY_VAR__);
                current_statement_begin__ = 147;
                local_scalar_t__ PE;
                (void) PE;  // dummy to suppress unused var warning

                stan::math::initialize(PE, DUMMY_VAR__);
                stan::math::fill(PE,DUMMY_VAR__);


                current_statement_begin__ = 150;
                stan::math::assign(mu_old, mu0);
                current_statement_begin__ = 151;
                stan::math::assign(k_old, k0);
                current_statement_begin__ = 152;
                stan::math::assign(sig2_old, sig20);
                current_statement_begin__ = 153;
                stan::math::assign(nu_old, nu0);
                current_statement_begin__ = 155;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 157;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 158;
                    stan::math::assign(k_new, (k_old + 1));
                    current_statement_begin__ = 159;
                    stan::math::assign(nu_new, (nu_old + 1));
                    current_statement_begin__ = 160;
                    stan::math::assign(mu_new, (((k_old / k_new) * mu_old) + ((1 / k_new) * get_base1(get_base1(offer,i,"offer",1),t,"offer",2))));
                    current_statement_begin__ = 161;
                    stan::math::assign(sig2_new, (((nu_old / nu_new) * sig2_old) + (((1 / nu_new) * (k_old / k_new)) * pow((get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - mu_old),2))));
                    current_statement_begin__ = 163;
                    stan::math::assign(PE, (get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - mu_old));
                    current_statement_begin__ = 164;
                    stan::math::assign(util, ((get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - (get_base1(alpha,i,"alpha",1) * stan::math::fmax((mu_new - get_base1(get_base1(offer,i,"offer",1),t,"offer",2)),0.0))) - (get_base1(beta,i,"beta",1) * stan::math::fmax((get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - mu_new),0.0))));
                    current_statement_begin__ = 166;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + bernoulli_logit_log(get_base1(get_base1(accept,i,"accept",1),t,"accept",2),(util * get_base1(tau,i,"tau",1)))), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 169;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                bernoulli_rng(inv_logit((util * get_base1(tau,i,"tau",1))), base_rng__), 
                                "assigning variable y_pred");
                    current_statement_begin__ = 172;
                    stan::math::assign(mu_old, mu_new);
                    current_statement_begin__ = 173;
                    stan::math::assign(sig2_old, sig2_new);
                    current_statement_begin__ = 174;
                    stan::math::assign(k_old, k_new);
                    current_statement_begin__ = 175;
                    stan::math::assign(nu_old, nu_new);
                }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 114;
            check_greater_or_equal(function__,"mu_alpha",mu_alpha,0);
            check_less_or_equal(function__,"mu_alpha",mu_alpha,20);
            current_statement_begin__ = 115;
            check_greater_or_equal(function__,"mu_beta",mu_beta,0);
            check_less_or_equal(function__,"mu_beta",mu_beta,10);
            current_statement_begin__ = 116;
            check_greater_or_equal(function__,"mu_tau",mu_tau,0);
            check_less_or_equal(function__,"mu_tau",mu_tau,10);
            current_statement_begin__ = 119;
            current_statement_begin__ = 122;

            // write generated quantities
        vars__.push_back(mu_alpha);
        vars__.push_back(mu_beta);
        vars__.push_back(mu_tau);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(y_pred[k_0__][k_1__]);
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_ug_bayes";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

}

typedef model_ug_bayes_namespace::model_ug_bayes stan_model;


#endif
