/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_pst_gainloss_Q_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_pst_gainloss_Q");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_pst_gainloss_Q");
    reader.add_event(128, 113, "end", "model_pst_gainloss_Q");
    return reader;
}

#include <meta_header.hpp>
 class model_pst_gainloss_Q : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > option1;
    vector<vector<int> > option2;
    vector<vector<int> > choice;
    vector<vector<double> > reward;
    vector_d initial_values;
public:
    model_pst_gainloss_Q(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_pst_gainloss_Q(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_pst_gainloss_Q_namespace::model_pst_gainloss_Q";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 19;
            validate_non_negative_index("Tsubj", "N", N);
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
            validate_non_negative_index("Tsubj", "N", N);
            Tsubj = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            size_t Tsubj_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
                Tsubj[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 21;
            validate_non_negative_index("option1", "N", N);
            validate_non_negative_index("option1", "T", T);
            context__.validate_dims("data initialization", "option1", "int", context__.to_vec(N,T));
            validate_non_negative_index("option1", "N", N);
            validate_non_negative_index("option1", "T", T);
            option1 = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("option1");
            pos__ = 0;
            size_t option1_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < option1_limit_1__; ++i_1__) {
                size_t option1_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < option1_limit_0__; ++i_0__) {
                    option1[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 22;
            validate_non_negative_index("option2", "N", N);
            validate_non_negative_index("option2", "T", T);
            context__.validate_dims("data initialization", "option2", "int", context__.to_vec(N,T));
            validate_non_negative_index("option2", "N", N);
            validate_non_negative_index("option2", "T", T);
            option2 = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("option2");
            pos__ = 0;
            size_t option2_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < option2_limit_1__; ++i_1__) {
                size_t option2_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < option2_limit_0__; ++i_0__) {
                    option2[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 23;
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "T", T);
            context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,T));
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "T", T);
            choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("choice");
            pos__ = 0;
            size_t choice_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
                size_t choice_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                    choice[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 24;
            validate_non_negative_index("reward", "N", N);
            validate_non_negative_index("reward", "T", T);
            context__.validate_dims("data initialization", "reward", "double", context__.to_vec(N,T));
            validate_non_negative_index("reward", "N", N);
            validate_non_negative_index("reward", "T", T);
            reward = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("reward");
            pos__ = 0;
            size_t reward_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < reward_limit_1__; ++i_1__) {
                size_t reward_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < reward_limit_0__; ++i_0__) {
                    reward[i_0__][i_1__] = vals_r__[pos__++];
                }
            }

            // validate, data variables
            current_statement_begin__ = 17;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 18;
            check_greater_or_equal(function__,"T",T,1);
            current_statement_begin__ = 19;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            }
            current_statement_begin__ = 21;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"option1[k0__][k1__]",option1[k0__][k1__],-(1));
                    check_less_or_equal(function__,"option1[k0__][k1__]",option1[k0__][k1__],6);
                }
            }
            current_statement_begin__ = 22;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"option2[k0__][k1__]",option2[k0__][k1__],-(1));
                    check_less_or_equal(function__,"option2[k0__][k1__]",option2[k0__][k1__],6);
                }
            }
            current_statement_begin__ = 23;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],-(1));
                    check_less_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 24;
            // initialize data variables
            current_statement_begin__ = 29;
            validate_non_negative_index("initial_values", "6", 6);
            initial_values = vector_d(static_cast<Eigen::VectorXd::Index>(6));
            stan::math::fill(initial_values,DUMMY_VAR__);

            current_statement_begin__ = 30;
            stan::math::assign(initial_values, rep_vector(0,6));

            // validate transformed data
            current_statement_begin__ = 29;

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 35;
            validate_non_negative_index("mu_pr", "3", 3);
            num_params_r__ += 3;
            current_statement_begin__ = 36;
            validate_non_negative_index("sigma", "3", 3);
            num_params_r__ += 3;
            current_statement_begin__ = 39;
            validate_non_negative_index("alpha_pos_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 40;
            validate_non_negative_index("alpha_neg_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 41;
            validate_non_negative_index("beta_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_pst_gainloss_Q() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "3", 3);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(3));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "3", 3);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("alpha_pos_pr")))
            throw std::runtime_error("variable alpha_pos_pr missing");
        vals_r__ = context__.vals_r("alpha_pos_pr");
        pos__ = 0U;
        validate_non_negative_index("alpha_pos_pr", "N", N);
        context__.validate_dims("initialization", "alpha_pos_pr", "vector_d", context__.to_vec(N));
        vector_d alpha_pos_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            alpha_pos_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_pos_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_pos_pr: ") + e.what());
        }

        if (!(context__.contains_r("alpha_neg_pr")))
            throw std::runtime_error("variable alpha_neg_pr missing");
        vals_r__ = context__.vals_r("alpha_neg_pr");
        pos__ = 0U;
        validate_non_negative_index("alpha_neg_pr", "N", N);
        context__.validate_dims("initialization", "alpha_neg_pr", "vector_d", context__.to_vec(N));
        vector_d alpha_neg_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            alpha_neg_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_neg_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_neg_pr: ") + e.what());
        }

        if (!(context__.contains_r("beta_pr")))
            throw std::runtime_error("variable beta_pr missing");
        vals_r__ = context__.vals_r("beta_pr");
        pos__ = 0U;
        validate_non_negative_index("beta_pr", "N", N);
        context__.validate_dims("initialization", "beta_pr", "vector_d", context__.to_vec(N));
        vector_d beta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            beta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(3,lp__);
            else
                mu_pr = in__.vector_constrain(3);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,3,lp__);
            else
                sigma = in__.vector_lb_constrain(0,3);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha_pos_pr;
            (void) alpha_pos_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha_pos_pr = in__.vector_constrain(N,lp__);
            else
                alpha_pos_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha_neg_pr;
            (void) alpha_neg_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha_neg_pr = in__.vector_constrain(N,lp__);
            else
                alpha_neg_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta_pr;
            (void) beta_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_pr = in__.vector_constrain(N,lp__);
            else
                beta_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 45;
            validate_non_negative_index("alpha_pos", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha_pos(static_cast<Eigen::VectorXd::Index>(N));
            (void) alpha_pos;  // dummy to suppress unused var warning

            stan::math::initialize(alpha_pos, DUMMY_VAR__);
            stan::math::fill(alpha_pos,DUMMY_VAR__);
            current_statement_begin__ = 46;
            validate_non_negative_index("alpha_neg", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha_neg(static_cast<Eigen::VectorXd::Index>(N));
            (void) alpha_neg;  // dummy to suppress unused var warning

            stan::math::initialize(alpha_neg, DUMMY_VAR__);
            stan::math::fill(alpha_neg,DUMMY_VAR__);
            current_statement_begin__ = 47;
            validate_non_negative_index("beta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
            (void) beta;  // dummy to suppress unused var warning

            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta,DUMMY_VAR__);


            current_statement_begin__ = 49;
            stan::math::assign(alpha_pos, Phi_approx(add(get_base1(mu_pr,1,"mu_pr",1),multiply(get_base1(sigma,1,"sigma",1),alpha_pos_pr))));
            current_statement_begin__ = 50;
            stan::math::assign(alpha_neg, Phi_approx(add(get_base1(mu_pr,2,"mu_pr",1),multiply(get_base1(sigma,2,"sigma",1),alpha_neg_pr))));
            current_statement_begin__ = 51;
            stan::math::assign(beta, multiply(Phi_approx(add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),beta_pr))),10));

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(alpha_pos(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: alpha_pos" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(alpha_neg(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: alpha_neg" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(beta(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 45;
            check_greater_or_equal(function__,"alpha_pos",alpha_pos,0);
            check_less_or_equal(function__,"alpha_pos",alpha_pos,1);
            current_statement_begin__ = 46;
            check_greater_or_equal(function__,"alpha_neg",alpha_neg,0);
            check_less_or_equal(function__,"alpha_neg",alpha_neg,1);
            current_statement_begin__ = 47;
            check_greater_or_equal(function__,"beta",beta,0);
            check_less_or_equal(function__,"beta",beta,10);

            // model body

            current_statement_begin__ = 56;
            lp_accum__.add(normal_log<propto__>(mu_pr, 0, 1));
            current_statement_begin__ = 57;
            lp_accum__.add(normal_log<propto__>(sigma, 0, 0.20000000000000001));
            current_statement_begin__ = 60;
            lp_accum__.add(normal_log<propto__>(alpha_pos_pr, 0, 1));
            current_statement_begin__ = 61;
            lp_accum__.add(normal_log<propto__>(alpha_neg_pr, 0, 1));
            current_statement_begin__ = 62;
            lp_accum__.add(normal_log<propto__>(beta_pr, 0, 1));
            current_statement_begin__ = 64;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 65;
                int co(0);
                (void) co;  // dummy to suppress unused var warning

                stan::math::fill(co, std::numeric_limits<int>::min());
                current_statement_begin__ = 66;
                local_scalar_t__ delta;
                (void) delta;  // dummy to suppress unused var warning

                stan::math::initialize(delta, DUMMY_VAR__);
                stan::math::fill(delta,DUMMY_VAR__);
                current_statement_begin__ = 67;
                local_scalar_t__ pe;
                (void) pe;  // dummy to suppress unused var warning

                stan::math::initialize(pe, DUMMY_VAR__);
                stan::math::fill(pe,DUMMY_VAR__);
                current_statement_begin__ = 68;
                local_scalar_t__ alpha;
                (void) alpha;  // dummy to suppress unused var warning

                stan::math::initialize(alpha, DUMMY_VAR__);
                stan::math::fill(alpha,DUMMY_VAR__);
                current_statement_begin__ = 69;
                validate_non_negative_index("ev", "6", 6);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  ev(static_cast<Eigen::VectorXd::Index>(6));
                (void) ev;  // dummy to suppress unused var warning

                stan::math::initialize(ev, DUMMY_VAR__);
                stan::math::fill(ev,DUMMY_VAR__);


                current_statement_begin__ = 71;
                stan::math::assign(ev, initial_values);
                current_statement_begin__ = 74;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 75;
                    stan::math::assign(co, (logical_gt(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),0) ? get_base1(get_base1(option1,i,"option1",1),t,"option1",2) : get_base1(get_base1(option2,i,"option2",1),t,"option2",2) ));
                    current_statement_begin__ = 78;
                    stan::math::assign(delta, (get_base1(ev,get_base1(get_base1(option1,i,"option1",1),t,"option1",2),"ev",1) - get_base1(ev,get_base1(get_base1(option2,i,"option2",1),t,"option2",2),"ev",1)));
                    current_statement_begin__ = 79;
                    lp_accum__.add(bernoulli_logit_log(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),(get_base1(beta,i,"beta",1) * delta)));
                    current_statement_begin__ = 81;
                    stan::math::assign(pe, (get_base1(get_base1(reward,i,"reward",1),t,"reward",2) - get_base1(ev,co,"ev",1)));
                    current_statement_begin__ = 82;
                    stan::math::assign(alpha, (logical_gte(pe,0) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(alpha_pos,i,"alpha_pos",1)) : stan::math::promote_scalar<local_scalar_t__>(get_base1(alpha_neg,i,"alpha_neg",1)) ));
                    current_statement_begin__ = 83;
                    stan::model::assign(ev, 
                                stan::model::cons_list(stan::model::index_uni(co), stan::model::nil_index_list()), 
                                (stan::model::rvalue(ev, stan::model::cons_list(stan::model::index_uni(co), stan::model::nil_index_list()), "ev") + (alpha * pe)), 
                                "assigning variable ev");
                }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("alpha_pos_pr");
        names__.push_back("alpha_neg_pr");
        names__.push_back("beta_pr");
        names__.push_back("alpha_pos");
        names__.push_back("alpha_neg");
        names__.push_back("beta");
        names__.push_back("mu_alpha_pos");
        names__.push_back("mu_alpha_neg");
        names__.push_back("mu_beta");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_pst_gainloss_Q_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d alpha_pos_pr = in__.vector_constrain(N);
        vector_d alpha_neg_pr = in__.vector_constrain(N);
        vector_d beta_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_pos_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_neg_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 45;
            validate_non_negative_index("alpha_pos", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha_pos(static_cast<Eigen::VectorXd::Index>(N));
            (void) alpha_pos;  // dummy to suppress unused var warning

            stan::math::initialize(alpha_pos, DUMMY_VAR__);
            stan::math::fill(alpha_pos,DUMMY_VAR__);
            current_statement_begin__ = 46;
            validate_non_negative_index("alpha_neg", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha_neg(static_cast<Eigen::VectorXd::Index>(N));
            (void) alpha_neg;  // dummy to suppress unused var warning

            stan::math::initialize(alpha_neg, DUMMY_VAR__);
            stan::math::fill(alpha_neg,DUMMY_VAR__);
            current_statement_begin__ = 47;
            validate_non_negative_index("beta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
            (void) beta;  // dummy to suppress unused var warning

            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta,DUMMY_VAR__);


            current_statement_begin__ = 49;
            stan::math::assign(alpha_pos, Phi_approx(add(get_base1(mu_pr,1,"mu_pr",1),multiply(get_base1(sigma,1,"sigma",1),alpha_pos_pr))));
            current_statement_begin__ = 50;
            stan::math::assign(alpha_neg, Phi_approx(add(get_base1(mu_pr,2,"mu_pr",1),multiply(get_base1(sigma,2,"sigma",1),alpha_neg_pr))));
            current_statement_begin__ = 51;
            stan::math::assign(beta, multiply(Phi_approx(add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),beta_pr))),10));

            // validate transformed parameters
            current_statement_begin__ = 45;
            check_greater_or_equal(function__,"alpha_pos",alpha_pos,0);
            check_less_or_equal(function__,"alpha_pos",alpha_pos,1);
            current_statement_begin__ = 46;
            check_greater_or_equal(function__,"alpha_neg",alpha_neg,0);
            check_less_or_equal(function__,"alpha_neg",alpha_neg,1);
            current_statement_begin__ = 47;
            check_greater_or_equal(function__,"beta",beta,0);
            check_less_or_equal(function__,"beta",beta,10);

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_pos[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_neg[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 90;
            local_scalar_t__ mu_alpha_pos;
            (void) mu_alpha_pos;  // dummy to suppress unused var warning

            stan::math::initialize(mu_alpha_pos, DUMMY_VAR__);
            stan::math::fill(mu_alpha_pos,DUMMY_VAR__);
            current_statement_begin__ = 91;
            local_scalar_t__ mu_alpha_neg;
            (void) mu_alpha_neg;  // dummy to suppress unused var warning

            stan::math::initialize(mu_alpha_neg, DUMMY_VAR__);
            stan::math::fill(mu_alpha_neg,DUMMY_VAR__);
            current_statement_begin__ = 92;
            local_scalar_t__ mu_beta;
            (void) mu_beta;  // dummy to suppress unused var warning

            stan::math::initialize(mu_beta, DUMMY_VAR__);
            stan::math::fill(mu_beta,DUMMY_VAR__);
            current_statement_begin__ = 95;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);


            current_statement_begin__ = 97;
            stan::math::assign(mu_alpha_pos, Phi_approx(get_base1(mu_pr,1,"mu_pr",1)));
            current_statement_begin__ = 98;
            stan::math::assign(mu_alpha_neg, Phi_approx(get_base1(mu_pr,2,"mu_pr",1)));
            current_statement_begin__ = 99;
            stan::math::assign(mu_beta, (Phi_approx(get_base1(mu_pr,3,"mu_pr",1)) * 10));

            current_statement_begin__ = 102;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 103;
                int co(0);
                (void) co;  // dummy to suppress unused var warning

                stan::math::fill(co, std::numeric_limits<int>::min());
                current_statement_begin__ = 104;
                local_scalar_t__ delta;
                (void) delta;  // dummy to suppress unused var warning

                stan::math::initialize(delta, DUMMY_VAR__);
                stan::math::fill(delta,DUMMY_VAR__);
                current_statement_begin__ = 105;
                local_scalar_t__ pe;
                (void) pe;  // dummy to suppress unused var warning

                stan::math::initialize(pe, DUMMY_VAR__);
                stan::math::fill(pe,DUMMY_VAR__);
                current_statement_begin__ = 106;
                local_scalar_t__ alpha;
                (void) alpha;  // dummy to suppress unused var warning

                stan::math::initialize(alpha, DUMMY_VAR__);
                stan::math::fill(alpha,DUMMY_VAR__);
                current_statement_begin__ = 107;
                validate_non_negative_index("ev", "6", 6);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  ev(static_cast<Eigen::VectorXd::Index>(6));
                (void) ev;  // dummy to suppress unused var warning

                stan::math::initialize(ev, DUMMY_VAR__);
                stan::math::fill(ev,DUMMY_VAR__);


                current_statement_begin__ = 109;
                stan::math::assign(ev, initial_values);
                current_statement_begin__ = 110;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 113;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 114;
                    stan::math::assign(co, (logical_gt(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),0) ? get_base1(get_base1(option1,i,"option1",1),t,"option1",2) : get_base1(get_base1(option2,i,"option2",1),t,"option2",2) ));
                    current_statement_begin__ = 117;
                    stan::math::assign(delta, (get_base1(ev,get_base1(get_base1(option1,i,"option1",1),t,"option1",2),"ev",1) - get_base1(ev,get_base1(get_base1(option2,i,"option2",1),t,"option2",2),"ev",1)));
                    current_statement_begin__ = 118;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + bernoulli_logit_log(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),(get_base1(beta,i,"beta",1) * delta))), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 120;
                    stan::math::assign(pe, (get_base1(get_base1(reward,i,"reward",1),t,"reward",2) - get_base1(ev,co,"ev",1)));
                    current_statement_begin__ = 121;
                    stan::math::assign(alpha, (logical_gte(pe,0) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(alpha_pos,i,"alpha_pos",1)) : stan::math::promote_scalar<local_scalar_t__>(get_base1(alpha_neg,i,"alpha_neg",1)) ));
                    current_statement_begin__ = 122;
                    stan::model::assign(ev, 
                                stan::model::cons_list(stan::model::index_uni(co), stan::model::nil_index_list()), 
                                (stan::model::rvalue(ev, stan::model::cons_list(stan::model::index_uni(co), stan::model::nil_index_list()), "ev") + (alpha * pe)), 
                                "assigning variable ev");
                }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 90;
            check_greater_or_equal(function__,"mu_alpha_pos",mu_alpha_pos,0);
            check_less_or_equal(function__,"mu_alpha_pos",mu_alpha_pos,1);
            current_statement_begin__ = 91;
            check_greater_or_equal(function__,"mu_alpha_neg",mu_alpha_neg,0);
            check_less_or_equal(function__,"mu_alpha_neg",mu_alpha_neg,1);
            current_statement_begin__ = 92;
            check_greater_or_equal(function__,"mu_beta",mu_beta,0);
            check_less_or_equal(function__,"mu_beta",mu_beta,10);
            current_statement_begin__ = 95;

            // write generated quantities
        vars__.push_back(mu_alpha_pos);
        vars__.push_back(mu_alpha_neg);
        vars__.push_back(mu_beta);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_pst_gainloss_Q";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pos_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_neg_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha_pos" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha_neg" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha_pos";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha_neg";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pos_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_neg_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha_pos" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha_neg" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha_pos";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha_neg";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}

typedef model_pst_gainloss_Q_namespace::model_pst_gainloss_Q stan_model;


#endif
