% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_utilities.R
\name{res_length}
\alias{res_length}
\title{Get H3 cell edge length}
\usage{
res_length(res = NULL, units = c("m", "km"), fast = TRUE)
}
\arguments{
\item{res}{Integer; Desired H3 resolution. See
\url{https://h3geo.org/docs/core-library/restable/} for allowable values and related dimensions.}

\item{units}{Length unit to report in, either meters or kilometers.}

\item{fast}{Logical; whether to retieve values from a locally stored table or
reclaculate from source.}
}
\value{
Numeric; H3 cell edge length
}
\description{
This function returns the average edge length of an H3 cell edge at a given
resolution.
}
\note{
This value is also the hexagon circumradius.
}
\examples{
# Return average H3 cell edge length at each resolution in kilometers
res_length(res = seq(0, 15), units = 'km')

}
