% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.head}
\alias{h2o.head}
\alias{h2o.tail}
\alias{head.Frame}
\alias{tail.Frame}
\title{Return the Head or Tail of an H2O Dataset.}
\usage{
h2o.head(x, ..., n = 6L)

\method{head}{Frame}(x, ..., n = 6L)

h2o.tail(x, ..., n = 6L)

\method{tail}{Frame}(x, ..., n = 6L)
}
\arguments{
\item{x}{An H2O Frame object.}

\item{...}{Further arguments passed to or from other methods.}

\item{n}{(Optional) A single integer. If positive, number of rows in x to return. If negative, all but the n first/last number of rows in x.}
}
\value{
A Frame containing the first or last n rows of an H2O Frame object.
}
\description{
Returns the first or last rows of an H2O Frame object.
}
\examples{
\donttest{
library(h2o)
h2o.init(ip = "localhost", port = 54321, startH2O = TRUE)
ausPath <- system.file("extdata", "australia.csv", package="h2o")
australia.hex <- h2o.uploadFile(path = ausPath)
head(australia.hex, 10)
tail(australia.hex, 10)
}
}

