% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf-idf.R
\name{h2o.tf_idf}
\alias{h2o.tf_idf}
\title{Computes TF-IDF values for each word in given documents.}
\usage{
h2o.tf_idf(
  frame,
  document_id_col,
  text_col,
  preprocess = TRUE,
  case_sensitive = TRUE
)
}
\arguments{
\item{frame}{documents or words frame for which TF-IDF values should be computed.}

\item{document_id_col}{index or name of a column containing document IDs.}

\item{text_col}{index or name of a column containing documents if `preprocess = TRUE`
or words if `preprocess = FALSE`.}

\item{preprocess}{whether input text data should be pre-processed. Defaults to `TRUE`.}

\item{case_sensitive}{whether input data should be treated as case sensitive. Defaults to `TRUE`.}
}
\value{
resulting frame with TF-IDF values.
         Row format: documentID, word, TF, IDF, TF-IDF
}
\description{
Computes TF-IDF values for each word in given documents.
}
