% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{h2o.loadModel}
\alias{h2o.loadModel}
\title{Load H2O Model from HDFS or Local Disk}
\usage{
h2o.loadModel(path)
}
\arguments{
\item{path}{The path of the H2O Model to be imported.}
}
\value{
Returns a \linkS4class{H2OModel} object of the class corresponding to the type of model
        loaded.
}
\description{
Load a saved H2O model from disk. (Note that ensemble binary models 
can now be loaded using this method.)
}
\examples{
\dontrun{
# library(h2o)
# h2o.init()
# prostate_path = system.file("extdata", "prostate.csv", package = "h2o")
# prostate = h2o.importFile(path = prostate_path)
# prostate_glm = h2o.glm(y = "CAPSULE", x = c("AGE", "RACE", "PSA", "DCAPS"),
#   training_frame = prostate, family = "binomial", alpha = 0.5)
# glmmodel_path = h2o.saveModel(prostate_glm, dir = "/Users/UserName/Desktop")
# glmmodel_load = h2o.loadModel(glmmodel_path)
}
}
\seealso{
\code{\link{h2o.saveModel}, \linkS4class{H2OModel}}
}
