% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communication.R
\name{h2o.api}
\alias{h2o.api}
\title{Perform a REST API request to a previously connected server.}
\usage{
h2o.api(endpoint, params = NULL, json = NULL)
}
\arguments{
\item{endpoint}{A H2O REST API endpoint.}

\item{params}{A list of params passed in the url.}

\item{json}{A list of params passed as a json payload.}
}
\value{
The parsed response.
}
\description{
This function is mostly for internal purposes, but may occasionally be useful for direct access to the backend H2O server.
It has same parameters as :meth:\verb{H2OConnection.request <h2o.backend.H2OConnection.request>}.
}
\details{
REST API endpoints can be obtained using:\preformatted{endpoints <- sapply(h2o.api("GET /3/Metadata/endpoints")$routes, function(r) paste(r$http_method, r$url_pattern))
}

For a given route, the supported params can be otained using:\preformatted{parameters <- sapply(h2o.api("GET /3/Metadata/schemas/\{route$input_schema\}")$schemas[[1]]$fields, function(f) \{ l <-list(); l[f$name] <- f$help; l \})
}
}
\examples{
\dontrun{
res <- h2o.api("GET /3/NetworkTest")
res$table
}
}
