% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{predict_leaf_node_assignment.H2OModel}
\alias{predict_leaf_node_assignment.H2OModel}
\alias{h2o.predict_leaf_node_assignment}
\title{Predict the Leaf Node Assignment on an H2O Model}
\usage{
predict_leaf_node_assignment.H2OModel(object, newdata, type = c("Path",
  "Node_ID"), ...)

h2o.predict_leaf_node_assignment(object, newdata, type = c("Path",
  "Node_ID"), ...)
}
\arguments{
\item{object}{a fitted \linkS4class{H2OModel} object for which prediction is
desired}

\item{newdata}{An H2OFrame object in which to look for
variables with which to predict.}

\item{type}{choice of either "Path" when tree paths are to be returned (default); or "Node_ID" when the output}

\item{...}{additional arguments to pass on.}
}
\value{
Returns an H2OFrame object with categorical leaf assignment identifiers for
        each tree in the model.
}
\description{
Obtains leaf node assignment from fitted H2O model objects.
}
\details{
For every row in the test set, return the leaf placements of the row in all the trees in the model.
Placements can be represented either by paths to the leaf nodes from the tree root or by H2O's internal identifiers.
The order of the rows in the results is the same as the order in which the
data was loaded
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
prostate$CAPSULE <- as.factor(prostate$CAPSULE)
prostate_gbm <- h2o.gbm(3:9, "CAPSULE", prostate)
h2o.predict(prostate_gbm, prostate)
h2o.predict_leaf_node_assignment(prostate_gbm, prostate)
}
}
\seealso{
\code{\link{h2o.gbm}} and  \code{\link{h2o.randomForest}} for model
         generation in h2o.
}
