% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.stringdist}
\alias{h2o.stringdist}
\title{Compute element-wise string distances between two H2OFrames}
\usage{
h2o.stringdist(x, y, method = c("lv", "lcs", "qgram", "jaccard", "jw",
  "soundex"), compare_empty = TRUE)
}
\arguments{
\item{x}{An H2OFrame}

\item{y}{A comparison H2OFrame}

\item{method}{A string identifier indicating what string distance measure to use. Must be one of:
"lv"                   - Levenshtein distance
"lcs"                  - Longest common substring distance
"qgram"                - q-gram distance
"jaccard"              - Jaccard distance between q-gram profiles
"jw"                   - Jaro, or Jaro-Winker distance
"soundex"              - Distance based on soundex encoding}

\item{compare_empty}{if set to FALSE, empty strings will be handled as NaNs}
}
\description{
Compute element-wise string distances between two H2OFrames. Both frames need to have the same
shape (N x M) and only contain string/factor columns. Return a matrix (H2OFrame) of shape N x M.
}
\examples{
\dontrun{
h2o.init()
x <- as.h2o(c("Martha", "Dwayne", "Dixon"))
y <- as.character(as.h2o(c("Marhta", "Duane", "Dicksonx")))
h2o.stringdist(x, y, method = "jw")
}
}
