% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.rank_within_group_by}
\alias{h2o.rank_within_group_by}
\title{This function will add a new column rank where the ranking is produced as follows:
1. sorts the H2OFrame by columns sorted in by columns specified in group_by_cols and sort_cols in the directions
  specified by the ascending for the sort_cols.  The sort directions for the group_by_cols are ascending only.
2. A new rank column is added to the frame which will contain a rank assignment performed next.  The user can
  choose to assign a name to this new column.  The default name is New_Rank_column.
3. For each groupby groups, a rank is assigned to the row starting from 1, 2, ... to the end of that group.
4. If sort_cols_sorted is TRUE, a final sort on the frame will be performed frame according to the sort_cols and
   the sort directions in ascending.  If sort_cols_sorted is FALSE (by default), the frame from step 3 will be
   returned as is with no extra sort.  This may provide a small speedup if desired.}
\usage{
h2o.rank_within_group_by(x, group_by_cols, sort_cols, ascending = NULL,
  new_col_name = "New_Rank_column", sort_cols_sorted = FALSE)
}
\arguments{
\item{x}{The H2OFrame input to be sorted.}

\item{group_by_cols}{a list of column names or indices to form the groupby groups}

\item{sort_cols}{a list of column names or indices for sorting}

\item{ascending}{a list of Boolean to determine if ascending sort (set to TRUE) is needed for each column in
sort_cols (optional).  Default is ascending sort for all.  To perform descending sort, set value to FALSE}

\item{new_col_name}{new column name for the newly added rank column if specified (optional).  Default name is
New_Rank_column.}

\item{sort_cols_sorted}{Boolean to determine if the final returned frame is to be sorted according to the sort_cols
 and sort directions in ascending.  Default is FALSE.

The following example is generated by Nidhi Mehta.

If the input frame is train:

ID Group_by_column        num data Column_to_arrange_by       num_1 fdata
12               1   2941.552    1                    3  -3177.9077     1
12               1   2941.552    1                    5 -13311.8247     1
12               2 -22722.174    1                    3  -3177.9077     1
12               2 -22722.174    1                    5 -13311.8247     1
13               3 -12776.884    1                    5 -18421.6171     0
13               3 -12776.884    1                    4  28080.1607     0
13               1  -6049.830    1                    5 -18421.6171     0
13               1  -6049.830    1                    4  28080.1607     0
15               3 -16995.346    1                    1  -9781.6373     0
16               1 -10003.593    0                    3 -61284.6900     0
16               3  26052.495    1                    3 -61284.6900     0
16               3 -22905.288    0                    3 -61284.6900     0
17               2 -13465.496    1                    2  12094.4851     1
17               2 -13465.496    1                    3 -11772.1338     1
17               2 -13465.496    1                    3   -415.1114     0
17               2  -3329.619    1                    2  12094.4851     1
17               2  -3329.619    1                    3 -11772.1338     1
17               2  -3329.619    1                    3   -415.1114     0

If the following commands are issued:
rankedF1 <- h2o.rank_within_group_by(train, c("Group_by_column"), c("Column_to_arrange_by"), c(TRUE))
h2o.summary(rankedF1)

The returned frame rankedF1 will look like this:
ID Group_by_column        num fdata Column_to_arrange_by       num_1 fdata.1 New_Rank_column
12               1   2941.552     1                    3  -3177.9077       1               1
16               1 -10003.593     0                    3 -61284.6900       0               2
13               1  -6049.830     0                    4  28080.1607       0               3
12               1   2941.552     1                    5 -13311.8247       1               4
13               1  -6049.830     0                    5 -18421.6171       0               5
17               2 -13465.496     0                    2  12094.4851       1               1
17               2  -3329.619     0                    2  12094.4851       1               2
12               2 -22722.174     1                    3  -3177.9077       1               3
17               2 -13465.496     0                    3 -11772.1338       1               4
17               2 -13465.496     0                    3   -415.1114       0               5
17               2  -3329.619     0                    3 -11772.1338       1               6
17               2  -3329.619     0                    3   -415.1114       0               7
12               2 -22722.174     1                    5 -13311.8247       1               8
15               3 -16995.346     1                    1  -9781.6373       0               1
16               3  26052.495     0                    3 -61284.6900       0               2
16               3 -22905.288     1                    3 -61284.6900       0               3
13               3 -12776.884     1                    4  28080.1607       0               4
13               3 -12776.884     1                    5 -18421.6171       0               5

If the following commands are issued:
rankedF1 <- h2o.rank_within_group_by(train, c("Group_by_column"), c("Column_to_arrange_by"), c(TRUE), sort_cols_sorted=TRUE)
h2o.summary(rankedF1)

The returned frame will be sorted according to sortCols and hence look like this instead:
ID Group_by_column        num fdata Column_to_arrange_by       num_1 fdata.1 New_Rank_column
15               3 -16995.346     1                    1  -9781.6373       0               1
17               2 -13465.496     0                    2  12094.4851       1               1
17               2  -3329.619     0                    2  12094.4851       1               2
12               1   2941.552     1                    3  -3177.9077       1               1
12               2 -22722.174     1                    3  -3177.9077       1               3
16               1 -10003.593     0                    3 -61284.6900       0               2
16               3  26052.495     0                    3 -61284.6900       0               2
16               3 -22905.288     1                    3 -61284.6900       0               3
17               2 -13465.496     0                    3 -11772.1338       1               4
17               2 -13465.496     0                    3   -415.1114       0               5
17               2  -3329.619     0                    3 -11772.1338       1               6
17               2  -3329.619     0                    3   -415.1114       0               7
13               3 -12776.884     1                    4  28080.1607       0               4
13               1  -6049.830     0                    4  28080.1607       0               3
12               1   2941.552     1                    5 -13311.8247       1               4
12               2 -22722.174     1                    5 -13311.8247       1               8
13               3 -12776.884     1                    5 -18421.6171       0               5
13               1  -6049.830     0                    5 -18421.6171       0               5}
}
\description{
This function will add a new column rank where the ranking is produced as follows:
1. sorts the H2OFrame by columns sorted in by columns specified in group_by_cols and sort_cols in the directions
  specified by the ascending for the sort_cols.  The sort directions for the group_by_cols are ascending only.
2. A new rank column is added to the frame which will contain a rank assignment performed next.  The user can
  choose to assign a name to this new column.  The default name is New_Rank_column.
3. For each groupby groups, a rank is assigned to the row starting from 1, 2, ... to the end of that group.
4. If sort_cols_sorted is TRUE, a final sort on the frame will be performed frame according to the sort_cols and
   the sort directions in ascending.  If sort_cols_sorted is FALSE (by default), the frame from step 3 will be
   returned as is with no extra sort.  This may provide a small speedup if desired.
}
