% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{h2o.generic}
\alias{h2o.generic}
\title{Imports a generic model into H2O. Such model can be used then used for scoring and obtaining
additional information about the model. The imported model has to be supported by H2O.}
\usage{
h2o.generic(model_id = NULL, model_key = NULL)
}
\arguments{
\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{model_key}{Key to the self-contained model archive already uploaded to H2O.}
}
\description{
Imports a generic model into H2O. Such model can be used then used for scoring and obtaining
additional information about the model. The imported model has to be supported by H2O.
}
\examples{
\dontrun{
# library(h2o)
# h2o.init()

# generic_model <- h2o.genericModel("/path/to/model.zip")
# predictions <- h2o.predict(generic_model, dataset)
}
}
