% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdelaunay.R
\name{plotHdelaunay}
\alias{plotHdelaunay}
\title{Plot hyperbolic Delaunay triangulation}
\usage{
plotHdelaunay(
  hdel,
  vertices = TRUE,
  edges = TRUE,
  circle = TRUE,
  color = "random",
  distinctArgs = list(seedcolors = c("#ff0000", "#00ff00", "#0000ff")),
  randomArgs = list(hue = "random", luminosity = "bright")
)
}
\arguments{
\item{hdel}{an output of \code{\link{hdelaunay}}}

\item{vertices}{Boolean, whether to plot the vertices}

\item{edges}{Boolean, whether to plot the edges}

\item{circle}{Boolean, whether to plot the unit circle; ignored for the
Ungar model}

\item{color}{this argument controls the colors of the triangles; it can be
\code{NA} for no color, \code{"random"} for random colors generated
with \code{\link[colorsGen]{randomColor}}, \code{"distinct"} for
distinct colors generated with
\code{\link[Polychrome]{createPalette}}, a single color,
a vector of colors (color \code{i} attributed to the \code{i}-th
triangle), or a vectorized function mapping each point in the unit
interval to a color}

\item{distinctArgs}{if \code{color = "distinct"}, a list of arguments
passed to \code{\link[Polychrome]{createPalette}}}

\item{randomArgs}{if \code{color = "random"}, a list of arguments passed
to \code{\link[colorsGen]{randomColor}}}
}
\value{
No returned value, just generates a plot.
}
\description{
Plot a hyperbolic Delaunay triangulation obtained
  with \code{\link{hdelaunay}}.
}
\examples{
library(gyro)
library(uniformly)
set.seed(666)

points <- runif_in_sphere(35L, d = 2)
hdel <- hdelaunay(points, model = "M")
plotHdelaunay(hdel)

points <- runif_in_sphere(35L, d = 2, r = 0.7)
hdel <- hdelaunay(points, model = "U")
plotHdelaunay(hdel)

# example with colors given by a function ####
library(gyro)
if(require("trekcolors")) {
  pal <- trek_pal("klingon")
} else {
  pal <- hcl.colors(32L, palette = "Rocket")
}

phi <- (1 + sqrt(5)) / 2
theta <- head(seq(0, pi/2, length.out = 11), -1L)
a <- phi^((2*theta/pi)^0.8 - 1)
u <- a * cos(theta)
v <- a * sin(theta)
x <- c(0, u, -v, -u, v)
y <- c(0, v, u, -v, -u)
pts <- cbind(x, y) / 1.03

hdel <- hdelaunay(pts, model = "M")

fcolor <- function(t){
  RGB <- colorRamp(pal)(t)
  rgb(RGB[, 1L], RGB[, 2L], RGB[, 3L], maxColorValue = 255)
}

plotHdelaunay(
  hdel, vertices = FALSE, circle = FALSE, color = fcolor
)
}
