% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/man_plot.R
\name{man_plot}
\alias{man_plot}
\title{Manhattan Plot}
\usage{
man_plot(
  data,
  chromCol = c("gray44", "black"),
  genomewideline = -log10(5e-08),
  suggestiveline = -log10(1e-05),
  chromosome = "ALL",
  annotatePval = FALSE,
  annotateSNP = NULL,
  annotateCol = "red",
  highlight = NULL,
  highlightCol = "green3",
  title = NULL
)
}
\arguments{
\item{data}{PLINK assoc output, tab-delimited, or a data.frame with "SNP", "CHR", "BP", and "P" columns.}

\item{chromCol}{A character vector indicating which colors to alternate for the chromosomes.}

\item{genomewideline}{Where to draw the "genome-wide significant" line. Default
-log10(5e-8). Set to FALSE or F to disable}

\item{suggestiveline}{Where to draw the "suggestive" line. Default
-log10(1e-5). Set to FALSE or F to disable.}

\item{chromosome}{An integer indicating which chromosome to plot. Default is "ALL".}

\item{annotatePval}{If set, SNPs with p-value less than or equal to this p-value will be annotated on the plot.}

\item{annotateSNP}{A character vector of SNPs in your dataset to annotate.
If some of the SNPs are not in your dataset, gwaRs will throw a warning message.}

\item{annotateCol}{A string denoting the color to use for the annotations.}

\item{highlight}{A character vector of SNPs in the dataset to highlight.
If some of the SNPs are not in your dataset, gwaRs will throw a warning message. Default is NULL.}

\item{highlightCol}{A string denoting the color to use to highlight the SNPs.}

\item{title}{A string denoting the title to use for the plot. Default is 'Manhattan Plot'}
}
\value{
A Manhattan plot.
}
\description{
Creates a Manhattan plot
}
\details{
Creates a Manhattan plot from PLINK assoc output (or any tab-delimited file or data frame with
"SNP", "CHR", "BP", and "P" columns).
}
\examples{
man_plot(gwasData)

}
\author{
Lindokuhle Nkambule
}
