% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sum_by}
\alias{sum_by}
\title{Efficient by-group (weighted) summation}
\usage{
sum_by(y, by, w = NULL, na_rm = TRUE, keep_sparse = FALSE)
}
\arguments{
\item{y}{A (sparse) vector, a (sparse) matrix or a data.frame. 
The object to perform by-group summation on.}

\item{by}{The factor variable defining the by-groups. Character variables
are coerced to factors.}

\item{w}{The optional row weights to be used in the summation.}

\item{na_rm}{Should \code{NA} values in \code{y} be removed (ie treated as 0 in the summation) ? 
Similar to \code{na.rm} argument in \code{\link[base]{sum}}, but \code{TRUE} by default. 
If \code{FALSE}, \code{NA} values in \code{y} produce \code{NA} values in the result.}

\item{keep_sparse}{When \code{y} is a sparse vector or a sparse matrix, should the result
also be sparse ? \code{FALSE} by default. As \code{\link[Matrix]{sparseVector-class}} does
not have a name attribute, when \code{y} is a sparseVector the result does not have any
name (and a warning is cast).}
}
\value{
A vector, a matrix or a data.frame depending on the type of \code{y}. If \code{y} is
sparse and \code{keep_sparse = TRUE}, then the result is also sparse (without names
when it is a sparse vector, see keep_sparse argument for details).
}
\description{
\code{sum_by} performs an efficient and optionally weighted 
by-group summation by using linear algebra and the Matrix package 
capabilities. The by-group summation is performed through matrix cross-product
of the \code{y} parameter (coerced to a matrix if needed) with a (very) sparse
matrix built up using the \code{by} and the (optional) \code{w} parameters. 

Compared to base R, dplyr or data.table alternatives, this implementation 
aims at being easier to use in a matrix-oriented context and can yield 
efficiency gains when the number of columns becomes high.
}
\examples{
# Data generation
set.seed(1)
n <- 100
p <- 10
H <- 3
y <- matrix(rnorm(n*p), ncol = p, dimnames = list(NULL, paste0("var", 1:10)))
y[1, 1] <- NA
by <- letters[sample.int(H, n, replace = TRUE)]
w <- rep(1, n)
w[by == "a"] <- 2

# Standard use
sum_by(y, by)

# Keeping the NAs
sum_by(y, by, na_rm = FALSE)

# With a weight
sum_by(y, by, w = w)

}
\author{
Martin Chevalier
}
