\name{read.snpdata.minimac}
\alias{read.snpdata.minimac}
\title{Read genotype dosages in the format output by minimac}
\description{
  Reads snp coding information and genotype data from paired
  \code{.info.gz} and \code{.dose.gz} files, as generated by the MACH and
  minimac genotype imputation programs, and returns the data in a
  standard format (see \link{snpdata}) that can be used by other
  functions in this package.
}
\usage{
read.snpdata.minimac(fileroot, tol.af = 0.01, phenotypes = NULL,
                  isuffix = ".info.gz", dsuffix = ".dose.gz")
}
\arguments{
  \item{fileroot}{a filename root to which suffixes (my default \code{.info.gz} and \code{.dose.gz})
    will be appended.}
  \item{tol.af}{a tolerence for checking allele frequencies between the
    two files read.}
  \item{phenotypes}{if not \code{NULL}, a data frame of phenotypes to be merged with the
    genotypes; must contain a column called MACHID which is used to
    match against the first column of the mldose file.}
  \item{isuffix}{a suffix to add to the filename root to make the name
    of the info file}
  \item{dsuffix}{a suffix to add to the filename root to make the name
    of the dosage file}
}
\details{
  This function is just a wrapper for \code{\link{read.snpdata.mach}}
  with different default isuffix and dsuffix arguments.
}
\value{
Returns a list with snpinfo and data slots, see \link{snpdata}.
}
\references{
  Information about the MACH and minimac programs for genotype imputation, including
  their output formats, can be found at
  \url{http://www.sph.umich.edu/csg/abecasis/MACH}.
}
\author{
  Toby Johnson \email{Toby.x.Johnson@gsk.com}
}