% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_column_merge.R
\name{modify_column_merge}
\alias{modify_column_merge}
\alias{remove_column_merge}
\title{Modify Column Merging}
\usage{
modify_column_merge(x, pattern, rows = NULL)

remove_column_merge(x, columns = everything())
}
\arguments{
\item{x}{(\code{gtsummary})\cr
gtsummary object}

\item{pattern}{glue syntax string indicating how to merge columns in
\code{x$table_body}. For example, to construct a confidence interval
use \code{"{conf.low}, {conf.high}"}.}

\item{rows}{(predicate \code{expression})\cr
Predicate expression to select rows in \code{x$table_body}.
Can be used to style footnote, formatting functions, missing symbols,
and text formatting. Default is \code{NULL}. See details below.}

\item{columns}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Selector of columns in \code{x$table_body}}
}
\value{
gtsummary table
}
\description{
Merge two or more columns in a gtsummary table.
Use \code{show_header_names()} to print underlying column names.
}
\section{Details}{

\enumerate{
\item Calling this function merely records the instructions to merge columns.
The actual merging occurs when the gtsummary table is printed or converted
with a function like \code{as_gt()}.
\item Because the column merging is delayed, it is recommended to perform
major modifications to the table, such as those with \code{tbl_merge()} and
\code{tbl_stack()}, before assigning merging instructions. Otherwise,
unexpected formatting may occur in the final table.
\item If this functionality is used in conjunction with \code{tbl_stack()} (which
includes \code{tbl_uvregression()}), there may be potential issues with printing.
When columns are stack AND when the column-merging is
defined with a quosure, you may run into issues due to the loss of the
environment when 2 or more quosures are combined. If the expression
version of the quosure is the same as the quosure (i.e. no evaluated
objects), there should be no issues.
}

This function is used internally with care, and \strong{it is \emph{not} recommended for users}.
}

\section{Future Updates}{

There are planned updates to the implementation of this function
with respect to the \verb{pattern=} argument.
Currently, this function replaces a numeric column with a
formatted character column following \verb{pattern=}.
Once \code{gt::cols_merge()} gains the \verb{rows=} argument the
implementation will be updated to use it, which will keep
numeric columns numeric. For the \emph{vast majority} of users,
\emph{the planned change will be go unnoticed}.
}

\examples{
\dontshow{if (gtsummary:::is_pkg_installed("cardx") && gtsummary:::is_pkg_installed("broom", ref = "cardx")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
trial |>
  tbl_summary(by = trt, missing = "no", include = c(age, marker, trt)) |>
  add_p(all_continuous() ~ "t.test", pvalue_fun = label_style_pvalue(prepend_p = TRUE)) |>
  modify_fmt_fun(statistic ~ label_style_sigfig()) |>
  modify_column_merge(pattern = "t = {statistic}; {p.value}") |>
  modify_header(statistic = "**t-test**")

# Example 2 ----------------------------------
lm(marker ~ age + grade, trial) |>
  tbl_regression() |>
  modify_column_merge(
    pattern = "{estimate} ({conf.low}, {conf.high})",
    rows = !is.na(estimate)
  )
\dontshow{\}) # examplesIf}
}
\seealso{
Other Advanced modifiers: 
\code{\link{modify_column_indent}()},
\code{\link{modify_table_styling}()}
}
\concept{Advanced modifiers}
