% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_q.R
\name{add_q}
\alias{add_q}
\title{Add multiple comparison adjustment}
\usage{
add_q(x, method = "fdr", pvalue_fun = NULL, quiet = NULL)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
a \code{gtsummary} object with a column named \code{"p.value"}}

\item{method}{(\code{string})\cr
String indicating method to be used for p-value adjustment. Methods from
\code{\link[stats:p.adjust]{stats::p.adjust()}} are accepted.  Default is \code{method='fdr'}.
Must be one of 'holm', 'hochberg', 'hommel', 'bonferroni', 'BH', 'BY', 'fdr', 'none'}

\item{pvalue_fun}{(\code{function})\cr
Function to round and format q-values. Default is the function specified
to round the existing \code{'p.value'} column.}

\item{quiet}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\description{
Adjustments to p-values are performed with \code{\link[stats:p.adjust]{stats::p.adjust()}}.
}
\examples{
\dontshow{if (gtsummary:::is_pkg_installed("cardx") && gtsummary:::is_pkg_installed("broom", ref = "cardx")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
add_q_ex1 <-
  trial |>
  tbl_summary(by = trt, include = c(trt, age, grade, response)) |>
  add_p() |>
  add_q()

# Example 2 ----------------------------------
trial |>
  tbl_uvregression(
    y = response,
    include = c("trt", "age", "grade"),
    method = glm,
    method.args = list(family = binomial),
    exponentiate = TRUE
  ) |>
  add_global_p() |>
  add_q()
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg, Esther Drill
}
