% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.tbl_regression}
\alias{plot.tbl_uvregression}
\title{Plot Regression Coefficients}
\usage{
\method{plot}{tbl_regression}(x, remove_header_rows = TRUE, remove_reference_rows = FALSE, ...)

\method{plot}{tbl_uvregression}(x, remove_header_rows = TRUE, remove_reference_rows = FALSE, ...)
}
\arguments{
\item{x}{'tbl_regression' or 'tbl_uvregression' object}

\item{remove_header_rows}{logical indicating whether to remove header rows
for categorical variables. Default is \code{TRUE}}

\item{remove_reference_rows}{logical indicating whether to remove reference rows
for categorical variables. Default is \code{FALSE}.}

\item{...}{arguments passed to \code{GGally::ggcoef_plot(...)}}
}
\value{
a ggplot
}
\description{
The \code{plot()} function extracts \code{x$table_body} and passes the it to
\code{GGally::ggcoef_plot()} along with a formatting options.
}
\details{
\lifecycle{experimental}
}
\examples{
\dontshow{if (broom.helpers::.assert_package("GGally", pkg_search = "gtsummary", boolean = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
glm(response ~ marker + grade, trial, family = binomial) \%>\%
  tbl_regression(
    add_estimate_to_reference_rows = TRUE,
    exponentiate = TRUE
  ) \%>\%
  plot()
\dontshow{\}) # examplesIf}
}
