% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_n.R
\name{add_n.tbl_summary}
\alias{add_n.tbl_summary}
\alias{add_n.tbl_svysummary}
\title{Add column with N}
\usage{
\method{add_n}{tbl_summary}(
  x,
  statistic = "{n}",
  col_label = "**N**",
  footnote = FALSE,
  last = FALSE,
  missing = NULL,
  ...
)

\method{add_n}{tbl_svysummary}(
  x,
  statistic = "{n}",
  col_label = "**N**",
  footnote = FALSE,
  last = FALSE,
  missing = NULL,
  ...
)
}
\arguments{
\item{x}{Object with class \code{tbl_summary} from the \link{tbl_summary} function or
with class \code{tbl_svysummary} from the \link{tbl_svysummary} function}

\item{statistic}{String indicating the statistic to report. Default is the
number of non-missing observation for each variable, \code{statistic = "{n}"}.
Other statistics available to report include:
\itemize{
\item \code{"{N}"} total number of observations,
\item \code{"{n}"} number of non-missing observations,
\item \code{"{n_miss}"} number of missing observations,
\item \code{"{p}"} percent non-missing data,
\item \code{"{p_miss}"} percent missing data
The argument uses \link[glue:glue]{glue::glue} syntax and multiple statistics may be reported,
e.g. \code{statistic = "{n} / {N} ({p}\%)"}
}}

\item{col_label}{String indicating the column label.  Default is \code{"**N**"}}

\item{footnote}{Logical argument indicating whether to print a footnote
clarifying the statistics presented. Default is \code{FALSE}}

\item{last}{Logical indicator to include N column last in table.
Default is \code{FALSE}, which will display N column first.}

\item{missing}{DEPRECATED. Logical argument indicating whether to print N
(\code{missing = FALSE}), or N missing (\code{missing = TRUE}).  Default is \code{FALSE}}

\item{...}{Not used}
}
\value{
A \code{tbl_summary} or \code{tbl_svysummary} object
}
\description{
For each variable in a \code{tbl_summary} table, the \code{add_n} function adds a column with the
total number of non-missing (or missing) observations
}
\section{Example Output}{

\if{html}{\figure{tbl_n_ex.png}{options: width=50\%}}
}

\examples{
tbl_n_ex <-
  trial[c("trt", "age", "grade", "response")] \%>\%
  tbl_summary(by = trt) \%>\%
  add_n()
}
\seealso{
Other tbl_summary tools: 
\code{\link{add_overall}()},
\code{\link{add_p.tbl_summary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_summary}()},
\code{\link{inline_text.tbl_survfit}()},
\code{\link{modify}},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_summary}()}

Other tbl_svysummary tools: 
\code{\link{add_overall}()},
\code{\link{add_p.tbl_svysummary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{modify}},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_svysummary}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_summary tools}
\concept{tbl_svysummary tools}
