% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_inputs.R
\name{assert_vector}
\alias{assert_vector}
\alias{assert_list}
\alias{assert_class}
\title{Assert that an input is a vector/list with desired properties}
\usage{
assert_vector(
  x,
  class,
  len = NULL,
  null_ok = FALSE,
  var_name = NULL,
  subset_of = NULL,
  named = FALSE,
  n_call = -1L
)

assert_list(x, len = NULL, null_ok = FALSE, named = FALSE)

assert_class(x, class, n_call = -1)
}
\arguments{
\item{x}{A vector/list. The input to be analysed.}

\item{class}{A string. The class that this input should inherit from.}

\item{len}{An integer. The length of the vector. If \code{NULL}, length is not
checked.}

\item{null_ok}{A logical. Whether the input could also be \code{NULL}.}

\item{var_name}{A string. The name of the variable in the informative
message. If \code{NULL}, the name is guessed from the function call.}

\item{subset_of}{A character vector. If \code{x} is a character vector, specifies
which values it can take. If \code{NULL}, values are not checked.}

\item{named}{A logical. Whether the input should be a named vector/list. If
\code{FALSE} this check is not enforced (i.e. the input object can be named even
if named is \code{FALSE}).}

\item{n_call}{A negative integer. The number of frames to go back to find the
call to associate the error generated by the function with. Defaults to the
parent frame (-1). This argument is only relevant to other assertion
functions that build on top of this one.}
}
\value{
\code{TRUE} if the check is successful. Throws an error describing the
issue with the input otherwise.
}
\description{
Assert that an input is a vector/list with desired properties
}
\concept{input assertion}
\keyword{internal}
