% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_plt_dist.R
\name{gt_plt_dist}
\alias{gt_plt_dist}
\title{Add distribution plots into rows of a \code{gt} table}
\usage{
gt_plt_dist(
  gt_object,
  column,
  type = "density",
  fig_dim = c(5, 30),
  line_color = "black",
  fill_color = "grey",
  bw = NULL,
  trim = FALSE,
  same_limit = TRUE
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{The column wherein the sparkline plot should replace existing data. Note that the data \emph{must} be represented as a list of numeric values ahead of time.}

\item{type}{A string indicating the type of plot to generate, accepts \code{"boxplot"}, \code{"histogram"}, \code{"rug_strip"} or \code{"density"}.}

\item{fig_dim}{A vector of two numbers indicating the height/width of the plot in mm at a DPI of 25.4, defaults to \code{c(5,30)}}

\item{line_color}{Color for the line, defaults to \code{"black"}. Accepts a named color (eg 'blue') or a hex color.}

\item{fill_color}{Color for the fill of histograms/density plots, defaults to \code{"grey"}. Accepts a named color (eg \code{'blue'}) or a hex color.}

\item{bw}{The bandwidth or binwidth, passed to \code{density()} or \code{ggplot2::geom_histogram()}. If \code{type = "density"}, then \code{bw} is passed to the \code{bw} argument, if \code{type = "histogram"}, then \code{bw} is passed to the \code{binwidth} argument.}

\item{trim}{A logical indicating whether to trim the values in \code{type = "density"} to a slight expansion beyond the observable range. Can help with long tails in \code{density} plots.}

\item{same_limit}{A logical indicating that the plots will use the same axis range (\code{TRUE}) or have individual axis ranges (\code{FALSE}).}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_plt_dist} function takes an existing \code{gt_tbl} object and
adds summary distribution sparklines via \code{ggplot2}. Note that these sparklines
are limited to density, histogram, boxplot or rug/strip charts. If you're
wanting to plot more traditional spark\strong{lines}, you can use \code{gtExtras::gt_plt_sparkline()}.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{ library(gt)
 gt_sparkline_tab <- mtcars \%>\%
    dplyr::group_by(cyl) \%>\%
    # must end up with list of data for each row in the input dataframe
    dplyr::summarize(mpg_data = list(mpg), .groups = "drop") \%>\%
    gt() \%>\%
    gt_plt_dist(mpg_data)
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{gt_plt_dist.png}{options: width=50\%}}
}

\section{Function ID}{

1-4
}

\seealso{
Other Plotting: 
\code{\link{gt_plt_bar_pct}()},
\code{\link{gt_plt_bar_stack}()},
\code{\link{gt_plt_bar}()},
\code{\link{gt_plt_percentile}()},
\code{\link{gt_plt_point}()},
\code{\link{gt_plt_sparkline}()},
\code{\link{gt_plt_winloss}()}
}
\concept{Plotting}
