% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_enthalpy_second_derivatives_CT_exact}
\alias{gsw_enthalpy_second_derivatives_CT_exact}
\title{Second Derivatives of Enthalpy (exact)}
\usage{
gsw_enthalpy_second_derivatives_CT_exact(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
A list containing \code{h_SA_SA} [ (J/kg)/(g/kg)^2 ], the second derivative of
enthalpy with respect to Absolute Salinity, \code{h_SA_CT} [ (J/kg)/(K*g/kg) ], the derivative of
enthalpy with respect to Absolute Salinity and Conservative Temperature,
and \code{h_CT_CT} [ (J/kg)/degC^2 ], the second derivative of
enthalpy with respect to Conservative Temperature.
}
\description{
Second Derivatives of Enthalpy (exact)
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p <- c(      10,      50,     125,     250,     600,    1000)
r <- gsw_enthalpy_second_derivatives_CT_exact(SA, CT, p)
stopifnot(all.equal(r$h_SA_SA, c(0.000082767011576, 0.000414469343141, 0.001089580017293,
                                 0.002472193425998, 0.006103171596320, 0.010377465312463)))
stopifnot(all.equal(r$h_SA_CT, c(0.000130320164426, 0.000655016236924, 0.001879127443985,
                                 0.005468695168037, 0.014315709000526, 0.025192691262061)))
stopifnot(all.equal(r$h_CT_CT, c(0.000714365642428, 0.003584965089168, 0.009733337653703,
                                 0.024044402143825, 0.061449390733344, 0.107333638394904)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_enthalpy_second_derivatives_CT_exact.html}
}
