% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_sigma0}
\alias{gsw_sigma0}
\title{Potential density anomaly referenced to 0 dbar}
\usage{
gsw_sigma0(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}
}
\value{
potential density anomaly [ kg/m^3 ]
}
\description{
This uses the 75-term density equation, and returns
potential density referenced to a pressure of 0 dbar,
minus 1000 kg/m^3.
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
sigma0 <- gsw_sigma0(SA,CT)
expect_equal(sigma0, c(21.797900819337656, 22.052215404397316, 23.892985307893923,
                       26.667608665972011, 27.107380455119710, 27.409748977090885))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html}
}
\seealso{
Other things related to density: \code{\link{gsw_CT_from_rho}},
  \code{\link{gsw_CT_maxdensity}},
  \code{\link{gsw_SA_from_rho}},
  \code{\link{gsw_alpha_on_beta}},
  \code{\link{gsw_alpha_wrt_t_exact}},
  \code{\link{gsw_alpha_wrt_t_ice}},
  \code{\link{gsw_alpha}},
  \code{\link{gsw_beta_const_t_exact}},
  \code{\link{gsw_beta}},
  \code{\link{gsw_pot_rho_t_exact}},
  \code{\link{gsw_rho_alpha_beta}},
  \code{\link{gsw_rho_first_derivatives_wrt_enthalpy}},
  \code{\link{gsw_rho_first_derivatives}},
  \code{\link{gsw_rho_ice}}, \code{\link{gsw_rho_t_exact}},
  \code{\link{gsw_rho}}, \code{\link{gsw_sigma1}},
  \code{\link{gsw_sigma2}}, \code{\link{gsw_sigma3}},
  \code{\link{gsw_sigma4}},
  \code{\link{gsw_specvol_alpha_beta}},
  \code{\link{gsw_specvol_anom_standard}},
  \code{\link{gsw_specvol_ice}},
  \code{\link{gsw_specvol_t_exact}},
  \code{\link{gsw_specvol}}
}
