% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_kappa}
\alias{gsw_kappa}
\title{Isentropic Compressibility of Seawater (75-term equation)}
\usage{
gsw_kappa(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
isentropic compressibility [ 1/Pa ] (not 1/dbar)
}
\description{
Isentropic Compressibility of Seawater (75-term equation)
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <-c( 28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p <- c(      10,      50,     125,     250,     600,    1000)
kappa <- gsw_kappa(SA, CT, p)
expect_equal(kappa*1e9, c(0.411343648791300, 0.411105416128094, 0.416566236026610,
                        0.435588650838751, 0.438782500588955, 0.439842289994702))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_kappa.html}
}
\seealso{
Other things related to compressibility: \code{\link{gsw_kappa_const_t_ice}},
  \code{\link{gsw_kappa_ice}},
  \code{\link{gsw_kappa_t_exact}}
}
