% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_from_entropy}
\alias{gsw_CT_from_entropy}
\title{Conservative Temperature from Entropy}
\usage{
gsw_CT_from_entropy(SA, entropy)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{entropy}{specific entropy [ J/(degC*kg) ]}
}
\value{
Conservative Temperature [ degC ]
}
\description{
Conservative Temperature from Entropy
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(      34.7118,  34.8915,  35.0256,  34.8472, 34.7366, 34.7324)
entropy <- c(400.3892, 395.4378, 319.8668, 146.7910, 98.6471, 62.7919)
CT <- gsw_CT_from_entropy(SA, entropy)
expect_equal(CT, c(28.809902787278070, 28.439199226786918, 22.786199266954270,
                 10.226197672488652, 6.827196739780282, 4.323602945446461))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_from_entropy.html}
}
\seealso{
Other things related to entropy: \code{\link{gsw_entropy_first_derivatives}},
  \code{\link{gsw_entropy_from_pt}},
  \code{\link{gsw_entropy_from_t}},
  \code{\link{gsw_entropy_ice}},
  \code{\link{gsw_pt_from_entropy}}
}
